/*
 * Decompiled with CFR 0.152.
 */
package ninja;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Singleton;
import com.google.inject.Stage;
import java.util.ArrayList;
import java.util.List;
import ninja.Configuration;
import ninja.Ninja;
import ninja.NinjaDefault;
import ninja.Router;
import ninja.application.ApplicationRoutes;
import ninja.lifecycle.LifecycleSupport;
import ninja.logging.LogbackConfigurator;
import ninja.scheduler.SchedulerSupport;
import ninja.utils.NinjaProperties;
import ninja.utils.NinjaPropertiesImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Bootstrap {
    private static final Logger logger = LoggerFactory.getLogger(Bootstrap.class);
    public static final String APPLICATION_GUICE_MODULE_CONVENTION_LOCATION = "conf.Module";
    public static final String APPLICATION_GUICE_SERVLET_MODULE_CONVENTION_LOCATION = "conf.ServletModule";
    public static final String ROUTES_CONVENTION_LOCATION = "conf.Routes";
    public static final String NINJA_CONVENTION_LOCATION = "conf.Ninja";
    private final NinjaPropertiesImpl ninjaProperties;
    private final List<Module> modulesToLoad;
    private final Optional<String> applicationModulesBasePackage;
    private Injector injector = null;

    public Bootstrap(NinjaPropertiesImpl ninjaProperties) {
        Preconditions.checkNotNull((Object)ninjaProperties);
        this.ninjaProperties = ninjaProperties;
        this.modulesToLoad = new ArrayList<Module>();
        this.applicationModulesBasePackage = Optional.fromNullable((Object)ninjaProperties.get("application.modules.package"));
    }

    public synchronized void boot() {
        this.initLogback();
        if (this.injector != null) {
            throw new RuntimeException("Bootstrap already booted");
        }
        try {
            this.configure();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to configure Ninja", e);
        }
        long startTime = System.currentTimeMillis();
        try {
            this.initInjector();
        }
        catch (Exception e) {
            throw new RuntimeException("Ninja injector cannot be generated. Please check log for further errors.", e);
        }
        long injectorStartupTime = System.currentTimeMillis() - startTime;
        logger.info("Ninja injector started in " + injectorStartupTime + " ms.");
        try {
            this.initRoutes();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to initialize Ninja routes", e);
        }
        Ninja ninja = (Ninja)this.injector.getInstance(Ninja.class);
        ninja.onFrameworkStart();
    }

    public synchronized void shutdown() {
        if (this.injector != null) {
            Ninja ninja = (Ninja)this.injector.getInstance(Ninja.class);
            ninja.onFrameworkShutdown();
            this.injector = null;
            Object var1_1 = null;
        } else {
            logger.error("Shutdown of Ninja not clean => injector already null.");
        }
    }

    public Injector getInjector() {
        return this.injector;
    }

    public void addModule(Module module) {
        this.modulesToLoad.add(module);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void configure() throws Exception {
        void var3_9;
        String applicationNinjaClassName;
        this.addModule(LifecycleSupport.getModule());
        this.addModule(SchedulerSupport.getModule());
        this.addModule((Module)new Configuration(this.ninjaProperties));
        String applicationModuleClassName = this.resolveApplicationClassName(APPLICATION_GUICE_MODULE_CONVENTION_LOCATION);
        if (this.doesClassExist(applicationModuleClassName)) {
            void var3_6;
            Class<?> applicationModuleClass = Class.forName(applicationModuleClassName);
            Object var3_3 = null;
            try {
                AbstractModule abstractModule = (AbstractModule)applicationModuleClass.getConstructor(NinjaProperties.class).newInstance(this.ninjaProperties);
            }
            catch (NoSuchMethodException e) {
                AbstractModule abstractModule = (AbstractModule)applicationModuleClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            this.addModule((Module)var3_6);
        }
        if (this.doesClassExist(applicationNinjaClassName = this.resolveApplicationClassName(NINJA_CONVENTION_LOCATION))) {
            Class<?> clazzPotentially = Class.forName(applicationNinjaClassName);
            if (!Ninja.class.isAssignableFrom(clazzPotentially)) {
                String ERROR_MESSAGE = String.format("Found a class %s in your application's conf directory. This class does not implement Ninja interface %s.  Please implement the interface or remove the class.", applicationNinjaClassName, Ninja.class.getName());
                logger.error(ERROR_MESSAGE);
                throw new IllegalStateException(ERROR_MESSAGE);
            }
            Class<?> clazz = clazzPotentially;
        } else {
            Class<NinjaDefault> clazz = NinjaDefault.class;
        }
        this.addModule((Module)new AbstractModule((Class)var3_9){
            final /* synthetic */ Class val$ninjaClass;
            {
                this.val$ninjaClass = clazz;
            }

            protected void configure() {
                this.bind(Ninja.class).to(this.val$ninjaClass).in(Singleton.class);
            }
        });
    }

    private void initInjector() throws Exception {
        this.injector = Guice.createInjector((Stage)Stage.PRODUCTION, this.modulesToLoad);
    }

    public void initRoutes() throws Exception {
        String applicationRoutesClassName = this.resolveApplicationClassName(ROUTES_CONVENTION_LOCATION);
        if (this.doesClassExist(applicationRoutesClassName)) {
            Class<?> clazz = Class.forName(applicationRoutesClassName);
            ApplicationRoutes applicationRoutes = (ApplicationRoutes)this.injector.getInstance(clazz);
            Router router = (Router)this.injector.getInstance(Router.class);
            applicationRoutes.init(router);
            router.compileRoutes();
        }
    }

    private void initLogback() {
        try {
            Class.forName("ch.qos.logback.classic.joran.JoranConfigurator");
            LogbackConfigurator.initConfiguration(this.ninjaProperties);
            logger.info("Successfully configured Logback.");
        }
        catch (ClassNotFoundException exception) {
            logger.info("Logback is not on classpath (you are probably using slf4j-jdk14). I did not configure anything. It's up to you now...", (Throwable)exception);
        }
    }

    protected boolean doesClassExist(String nameWithPackage) {
        boolean exists = false;
        try {
            Class.forName(nameWithPackage, false, this.getClass().getClassLoader());
            exists = true;
        }
        catch (ClassNotFoundException e) {
            exists = false;
        }
        return exists;
    }

    protected String resolveApplicationClassName(String classLocationAsDefinedByNinja) {
        if (this.applicationModulesBasePackage.isPresent()) {
            return (String)this.applicationModulesBasePackage.get() + '.' + classLocationAsDefinedByNinja;
        }
        return classLocationAsDefinedByNinja;
    }
}

