/*
 * Decompiled with CFR 0.152.
 */
package ninja;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Singleton;
import com.google.inject.multibindings.OptionalBinder;
import ninja.RouteBuilder;
import ninja.RouteBuilderImpl;
import ninja.Router;
import ninja.RouterImpl;
import ninja.cache.Cache;
import ninja.cache.CacheProvider;
import ninja.jpa.JpaModule;
import ninja.migrations.MigrationInitializer;
import ninja.postoffice.Postoffice;
import ninja.postoffice.guice.PostofficeProvider;
import ninja.utils.LoggerProvider;
import ninja.utils.NinjaProperties;
import ninja.utils.NinjaPropertiesImpl;
import ninja.utils.ObjectMapperProvider;
import ninja.utils.XmlMapperProvider;
import org.slf4j.Logger;

public class Configuration
extends AbstractModule {
    private final NinjaPropertiesImpl ninjaProperties;

    public Configuration(NinjaPropertiesImpl ninjaProperties) {
        this.ninjaProperties = ninjaProperties;
    }

    public void configure() {
        System.setProperty("file.encoding", "utf-8");
        OptionalBinder.newOptionalBinder((Binder)this.binder(), ObjectMapper.class).setDefault().toProvider(ObjectMapperProvider.class).in(Singleton.class);
        OptionalBinder.newOptionalBinder((Binder)this.binder(), XmlMapper.class).setDefault().toProvider(XmlMapperProvider.class).in(Singleton.class);
        this.bind(RouteBuilder.class).to(RouteBuilderImpl.class);
        this.bind(Router.class).to(RouterImpl.class).in(Singleton.class);
        this.bind(Logger.class).toProvider(LoggerProvider.class);
        this.ninjaProperties.bindProperties(this.binder());
        this.bind(NinjaProperties.class).toInstance((Object)this.ninjaProperties);
        this.bind(Postoffice.class).toProvider(PostofficeProvider.class);
        this.bind(Cache.class).toProvider(CacheProvider.class);
        this.bind(MigrationInitializer.class).asEagerSingleton();
        this.install((Module)new JpaModule(this.ninjaProperties));
    }
}

