/*
 * Decompiled with CFR 0.152.
 */
package ninja;

import com.google.common.base.Optional;
import ninja.AsyncResult;
import ninja.Result;

public class Results {
    public static Result status(int statusCode) {
        Result result = new Result(statusCode);
        return result;
    }

    public static Result ok() {
        return Results.status(200);
    }

    public static Result created(Optional<String> url) {
        Result result = Results.status(201);
        if (url.isPresent()) {
            result.addHeader("Location", (String)url.get());
        }
        return result;
    }

    public static Result notFound() {
        return Results.status(404);
    }

    public static Result forbidden() {
        return Results.status(403);
    }

    public static Result unauthorized() {
        return Results.status(401);
    }

    public static Result badRequest() {
        return Results.status(400);
    }

    public static Result noContent() {
        return Results.status(204).render(Result.NO_HTTP_BODY);
    }

    public static Result internalServerError() {
        return Results.status(500);
    }

    public static Result redirect(String url) {
        Result result = Results.status(303);
        result.addHeader("Location", url);
        result.render(Result.NO_HTTP_BODY);
        return result;
    }

    public static Result redirectTemporary(String url) {
        Result result = Results.status(307);
        result.addHeader("Location", url);
        result.render(Result.NO_HTTP_BODY);
        return result;
    }

    public static Result contentType(String contentType) {
        Result result = Results.status(200);
        result.contentType(contentType);
        return result;
    }

    public static Result html() {
        Result result = Results.status(200);
        result.contentType("text/html");
        return result;
    }

    public static Result text() {
        Result result = Results.status(200);
        result.contentType("text/plain");
        return result;
    }

    public static Result json() {
        Result result = Results.status(200).json();
        return result;
    }

    public static Result jsonp() {
        Result result = Results.status(200).jsonp();
        return result;
    }

    public static Result xml() {
        Result result = Results.status(200).xml();
        return result;
    }

    public static Result TODO() {
        Result result = Results.status(501);
        result.contentType("application/json");
        return result;
    }

    public static AsyncResult async() {
        return new AsyncResult();
    }
}

