/*
 * Decompiled with CFR 0.152.
 */
package ninja;

import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import com.google.inject.Injector;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ninja.Route;
import ninja.RouteBuilder;
import ninja.RouteBuilderImpl;
import ninja.Router;
import ninja.utils.NinjaProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RouterImpl
implements Router {
    private final NinjaProperties ninjaProperties;
    private final Logger logger = LoggerFactory.getLogger(RouterImpl.class);
    private final List<RouteBuilderImpl> allRouteBuilders = new ArrayList<RouteBuilderImpl>();
    private final Injector injector;
    private List<Route> routes;
    private final String VARIABLE_PART_PATTERN_WITH_PLACEHOLDER = "\\{(%s)(:\\s([^}]*))?\\}";

    @Inject
    public RouterImpl(Injector injector, NinjaProperties ninjaProperties) {
        this.injector = injector;
        this.ninjaProperties = ninjaProperties;
    }

    @Override
    public Route getRouteFor(String httpMethod, String uri) {
        if (this.routes == null) {
            throw new IllegalStateException("Attempt to get route when routes not compiled");
        }
        for (Route route : this.routes) {
            if (!route.matches(httpMethod, uri)) continue;
            return route;
        }
        return null;
    }

    @Override
    public String getReverseRoute(Class<?> controllerClass, String controllerMethodName) {
        Optional parameterMap = Optional.absent();
        return this.getReverseRoute(controllerClass, controllerMethodName, (Optional<Map<String, Object>>)parameterMap);
    }

    @Override
    public String getReverseRoute(Class<?> controllerClass, String controllerMethodName, Object ... parameterMap) {
        if (parameterMap.length % 2 != 0) {
            this.logger.error("Always provide key (as String) value (as Object) pairs in parameterMap. That means providing e.g. 2, 4, 6... objects.");
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>(parameterMap.length / 2);
        for (int i = 0; i < parameterMap.length; i += 2) {
            map.put((String)parameterMap[i], parameterMap[i + 1]);
        }
        return this.getReverseRoute(controllerClass, controllerMethodName, (Optional<Map<String, Object>>)Optional.of(map));
    }

    @Override
    public String getReverseRoute(Class<?> controllerClass, String controllerMethodName, Optional<Map<String, Object>> parameterMap) {
        if (this.routes == null) {
            throw new IllegalStateException("Attempt to get route when routes not compiled");
        }
        Optional<Route> route = this.getRouteForControllerClassAndMethod(controllerClass, controllerMethodName);
        if (route.isPresent()) {
            String urlWithReplacedPlaceholders = this.replaceVariablePartsOfUrlWithValuesProvidedByUser(((Route)route.get()).getUrl(), parameterMap);
            String finalUrl = this.addContextPathToUrlIfAvailable(urlWithReplacedPlaceholders, this.ninjaProperties);
            return finalUrl;
        }
        this.logger.info("Could not find any reverse route for the method {} of the Controller class {}", (Object)controllerMethodName, (Object)controllerClass.getSimpleName());
        return null;
    }

    @Override
    public String getReverseRoute(Class<?> controllerClass, String controllerMethodName, Map<String, Object> parameterMap) {
        Optional parameterMapOptional = Optional.fromNullable(parameterMap);
        return this.getReverseRoute(controllerClass, controllerMethodName, (Optional<Map<String, Object>>)parameterMapOptional);
    }

    @Override
    public void compileRoutes() {
        if (this.routes != null) {
            throw new IllegalStateException("Routes already compiled");
        }
        ArrayList<Route> routes = new ArrayList<Route>();
        for (RouteBuilderImpl routeBuilder : this.allRouteBuilders) {
            routes.add(routeBuilder.buildRoute(this.injector));
        }
        this.routes = ImmutableList.copyOf(routes);
        this.logRoutes();
    }

    @Override
    public List<Route> getRoutes() {
        if (this.routes == null) {
            throw new IllegalStateException("Routes have not been compiled");
        }
        return this.routes;
    }

    @Override
    public RouteBuilder GET() {
        RouteBuilderImpl routeBuilder = new RouteBuilderImpl().GET();
        this.allRouteBuilders.add(routeBuilder);
        return routeBuilder;
    }

    @Override
    public RouteBuilder POST() {
        RouteBuilderImpl routeBuilder = new RouteBuilderImpl().POST();
        this.allRouteBuilders.add(routeBuilder);
        return routeBuilder;
    }

    @Override
    public RouteBuilder PUT() {
        RouteBuilderImpl routeBuilder = new RouteBuilderImpl().PUT();
        this.allRouteBuilders.add(routeBuilder);
        return routeBuilder;
    }

    @Override
    public RouteBuilder DELETE() {
        RouteBuilderImpl routeBuilder = new RouteBuilderImpl().DELETE();
        this.allRouteBuilders.add(routeBuilder);
        return routeBuilder;
    }

    @Override
    public RouteBuilder OPTIONS() {
        RouteBuilderImpl routeBuilder = new RouteBuilderImpl().OPTIONS();
        this.allRouteBuilders.add(routeBuilder);
        return routeBuilder;
    }

    @Override
    public RouteBuilder HEAD() {
        RouteBuilderImpl routeBuilder = new RouteBuilderImpl().HEAD();
        this.allRouteBuilders.add(routeBuilder);
        return routeBuilder;
    }

    @Override
    public RouteBuilder METHOD(String method) {
        RouteBuilderImpl routeBuilder = new RouteBuilderImpl().METHOD(method);
        this.allRouteBuilders.add(routeBuilder);
        return routeBuilder;
    }

    private Optional<Route> getRouteForControllerClassAndMethod(Class<?> controllerClass, String controllerMethodName) {
        for (Route route : this.routes) {
            if (route.getControllerClass() == null || !route.getControllerClass().equals(controllerClass) || !route.getControllerMethod().getName().equals(controllerMethodName)) continue;
            return Optional.of((Object)route);
        }
        return Optional.absent();
    }

    private String replaceVariablePartsOfUrlWithValuesProvidedByUser(String routeUrlWithVariableParts, Optional<Map<String, Object>> parameterMap) {
        String urlWithReplacedPlaceholders = routeUrlWithVariableParts;
        if (parameterMap.isPresent()) {
            HashMap queryParameterMap = new HashMap(((Map)parameterMap.get()).size());
            for (Map.Entry parameterPair : ((Map)parameterMap.get()).entrySet()) {
                boolean foundAsPathParameter = false;
                StringBuffer stringBuffer = new StringBuffer();
                String buffer = String.format("\\{(%s)(:\\s([^}]*))?\\}", parameterPair.getKey());
                Pattern PATTERN = Pattern.compile(buffer);
                Matcher matcher = PATTERN.matcher(urlWithReplacedPlaceholders);
                while (matcher.find()) {
                    String resultingRegexReplacement = parameterPair.getValue().toString();
                    matcher.appendReplacement(stringBuffer, resultingRegexReplacement);
                    foundAsPathParameter = true;
                }
                matcher.appendTail(stringBuffer);
                urlWithReplacedPlaceholders = stringBuffer.toString();
                if (foundAsPathParameter) continue;
                queryParameterMap.put(parameterPair.getKey(), parameterPair.getValue());
            }
            if (queryParameterMap.size() > 0) {
                StringBuffer queryParameterStringBuffer = new StringBuffer();
                Iterator iterator = queryParameterMap.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry queryParameterEntry = iterator.next();
                    queryParameterStringBuffer.append((String)queryParameterEntry.getKey());
                    queryParameterStringBuffer.append("=");
                    queryParameterStringBuffer.append(queryParameterEntry.getValue());
                    if (!iterator.hasNext()) continue;
                    queryParameterStringBuffer.append("&");
                }
                urlWithReplacedPlaceholders = urlWithReplacedPlaceholders + "?" + queryParameterStringBuffer.toString();
            }
        }
        return urlWithReplacedPlaceholders;
    }

    private String addContextPathToUrlIfAvailable(String routeWithoutContextPath, NinjaProperties ninjaProperties) {
        return ninjaProperties.getContextPath() + routeWithoutContextPath;
    }

    private void logRoutes() {
        int maxMethodLen = 0;
        int maxPathLen = 0;
        int maxControllerLen = 0;
        for (Route route : this.getRoutes()) {
            maxMethodLen = Math.max(maxMethodLen, route.getHttpMethod().length());
            maxPathLen = Math.max(maxPathLen, route.getUri().length());
            if (route.getControllerClass() == null) continue;
            int controllerLen = route.getControllerClass().getName().length() + route.getControllerMethod().getName().length();
            maxControllerLen = Math.max(maxControllerLen, controllerLen);
        }
        int borderLen = 10 + maxMethodLen + maxPathLen + maxControllerLen;
        String border = Strings.padEnd((String)"", (int)borderLen, (char)'-');
        this.logger.info(border);
        this.logger.info("Registered routes");
        this.logger.info(border);
        for (Route route : this.getRoutes()) {
            if (route.getControllerClass() != null) {
                this.logger.info("{} {}  =>  {}.{}()", new Object[]{Strings.padEnd((String)route.getHttpMethod(), (int)maxMethodLen, (char)' '), Strings.padEnd((String)route.getUri(), (int)maxPathLen, (char)' '), route.getControllerClass().getName(), route.getControllerMethod().getName()});
                continue;
            }
            this.logger.info("{} {}", (Object)route.getHttpMethod(), (Object)route.getUri());
        }
    }
}

