/*
 * Decompiled with CFR 0.152.
 */
package ninja.bodyparser;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import java.io.InputStream;
import ninja.Context;
import ninja.bodyparser.BodyParserEngine;
import ninja.exceptions.BadRequestException;

@Singleton
public class BodyParserEngineJson
implements BodyParserEngine {
    private final ObjectMapper objectMapper;

    @Inject
    public BodyParserEngineJson(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> T invoke(Context context, Class<T> classOfT) {
        try (InputStream inputStream = context.getInputStream();){
            Object object = this.objectMapper.readValue(inputStream, classOfT);
            return (T)object;
        }
        catch (JsonParseException | JsonMappingException ex) {
            throw new BadRequestException("Error parsing incoming Json", ex);
        }
        catch (IOException e) {
            throw new BadRequestException("Invalid Json document", e);
        }
    }

    @Override
    public String getContentType() {
        return "application/json";
    }
}

