/*
 * Decompiled with CFR 0.152.
 */
package ninja.bodyparser;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.inject.Binding;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import ninja.bodyparser.BodyParserEngine;
import ninja.bodyparser.BodyParserEngineJson;
import ninja.bodyparser.BodyParserEngineManager;
import ninja.bodyparser.BodyParserEnginePost;
import ninja.bodyparser.BodyParserEngineXml;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class BodyParserEngineManagerImpl
implements BodyParserEngineManager {
    private final Logger logger = LoggerFactory.getLogger(BodyParserEngineManagerImpl.class);
    private final Map<String, Provider<? extends BodyParserEngine>> contentTypeToBodyParserMap;

    @Inject
    public BodyParserEngineManagerImpl(Provider<BodyParserEnginePost> bodyParserEnginePost, Provider<BodyParserEngineJson> bodyParserEngineJson, Provider<BodyParserEngineXml> bodyParserEngineXml, Injector injector) {
        HashMap map = Maps.newHashMap();
        map.put(((BodyParserEnginePost)bodyParserEnginePost.get()).getContentType(), bodyParserEnginePost);
        map.put(((BodyParserEngineJson)bodyParserEngineJson.get()).getContentType(), bodyParserEngineJson);
        map.put(((BodyParserEngineXml)bodyParserEngineXml.get()).getContentType(), bodyParserEngineXml);
        for (Map.Entry binding : injector.getBindings().entrySet()) {
            if (!BodyParserEngine.class.isAssignableFrom(((Key)binding.getKey()).getTypeLiteral().getRawType())) continue;
            Provider provider = ((Binding)binding.getValue()).getProvider();
            map.put(((BodyParserEngine)provider.get()).getContentType(), provider);
        }
        this.contentTypeToBodyParserMap = ImmutableMap.copyOf((Map)map);
        this.logBodyParserEngines();
    }

    @Override
    public Set<String> getContentTypes() {
        return ImmutableSet.copyOf(this.contentTypeToBodyParserMap.keySet());
    }

    @Override
    public BodyParserEngine getBodyParserEngineForContentType(String contentType) {
        Provider<? extends BodyParserEngine> provider = this.contentTypeToBodyParserMap.get(contentType);
        if (provider != null) {
            return (BodyParserEngine)provider.get();
        }
        return null;
    }

    protected void logBodyParserEngines() {
        ArrayList outputTypes = Lists.newArrayList(this.getContentTypes());
        Collections.sort(outputTypes);
        int maxContentTypeLen = 0;
        int maxBodyParserEngineLen = 0;
        for (String contentType : outputTypes) {
            BodyParserEngine bodyParserEngine = this.getBodyParserEngineForContentType(contentType);
            maxContentTypeLen = Math.max(maxContentTypeLen, contentType.length());
            maxBodyParserEngineLen = Math.max(maxBodyParserEngineLen, bodyParserEngine.getClass().getName().length());
        }
        int borderLen = 6 + maxContentTypeLen + maxBodyParserEngineLen;
        String border = Strings.padEnd((String)"", (int)borderLen, (char)'-');
        this.logger.info(border);
        this.logger.info("Registered request bodyparser engines");
        this.logger.info(border);
        for (String contentType : outputTypes) {
            BodyParserEngine templateEngine = this.getBodyParserEngineForContentType(contentType);
            this.logger.info("{}  =>  {}", (Object)Strings.padEnd((String)contentType, (int)maxContentTypeLen, (char)' '), (Object)templateEngine.getClass().getName());
        }
    }
}

