/*
 * Decompiled with CFR 0.152.
 */
package ninja.bodyparser;

import com.google.common.collect.Sets;
import com.google.inject.Singleton;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import ninja.Context;
import ninja.bodyparser.BodyParserEngine;
import ninja.utils.SwissKnife;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class BodyParserEnginePost
implements BodyParserEngine {
    private final Logger logger = LoggerFactory.getLogger(BodyParserEnginePost.class);

    @Override
    public <T> T invoke(Context context, Class<T> classOfT) {
        T t = null;
        try {
            t = classOfT.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            this.logger.error("Can't create new instance of class {}", (Object)classOfT.getName(), (Object)e);
            return null;
        }
        Set<String> declaredFields = this.getAllDeclaredFieldsAsStringSet(classOfT);
        for (Map.Entry<String, String[]> ent : context.getParameters().entrySet()) {
            if (!declaredFields.contains(ent.getKey())) continue;
            try {
                Field field = classOfT.getDeclaredField(ent.getKey());
                Class<?> fieldType = field.getType();
                field.setAccessible(true);
                String[] values = ent.getValue();
                Object convertedValue = Collection.class.isAssignableFrom(fieldType) ? SwissKnife.convertCollection(values, this.getGenericType(field)) : (fieldType.isArray() ? SwissKnife.convertArray(values, fieldType.getComponentType()) : SwissKnife.convert(values[0], fieldType));
                if (convertedValue == null) continue;
                field.set(t, convertedValue);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
                this.logger.warn("Error parsing incoming Post request into class {}. Key {} and value {}.", new Object[]{classOfT.getName(), ent.getKey(), ent.getValue(), e});
            }
        }
        return t;
    }

    @Override
    public String getContentType() {
        return "application/x-www-form-urlencoded";
    }

    private <T> Set<String> getAllDeclaredFieldsAsStringSet(Class<T> clazz) {
        HashSet declaredFields = Sets.newHashSet();
        for (Field field : clazz.getDeclaredFields()) {
            declaredFields.add(field.getName());
        }
        return declaredFields;
    }

    private Class<?> getGenericType(Field field) {
        ParameterizedType genericType = (ParameterizedType)field.getGenericType();
        return (Class)genericType.getActualTypeArguments()[0];
    }
}

