/*
 * Decompiled with CFR 0.152.
 */
package ninja.bodyparser;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import ninja.Context;
import ninja.bodyparser.BodyParserEngine;
import ninja.exceptions.BadRequestException;

@Singleton
public class BodyParserEngineXml
implements BodyParserEngine {
    private final XmlMapper xmlMapper;

    @Inject
    public BodyParserEngineXml(XmlMapper xmlMapper) {
        this.xmlMapper = xmlMapper;
    }

    @Override
    public <T> T invoke(Context context, Class<T> classOfT) {
        try {
            return (T)this.xmlMapper.readValue(context.getInputStream(), classOfT);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new BadRequestException("Error parsing incoming Xml", e);
        }
        catch (IOException e) {
            throw new BadRequestException("Invalid Xml document", e);
        }
    }

    @Override
    public String getContentType() {
        return "application/xml";
    }
}

