/*
 * Decompiled with CFR 0.152.
 */
package ninja.cache;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.security.auth.callback.CallbackHandler;
import net.spy.memcached.AddrUtil;
import net.spy.memcached.ConnectionFactory;
import net.spy.memcached.ConnectionFactoryBuilder;
import net.spy.memcached.MemcachedClient;
import net.spy.memcached.auth.AuthDescriptor;
import net.spy.memcached.auth.PlainCallbackHandler;
import net.spy.memcached.internal.BulkFuture;
import net.spy.memcached.internal.GetFuture;
import net.spy.memcached.internal.OperationFuture;
import net.spy.memcached.transcoders.SerializingTranscoder;
import net.spy.memcached.transcoders.Transcoder;
import ninja.cache.Cache;
import ninja.lifecycle.Dispose;
import ninja.utils.NinjaProperties;
import org.slf4j.Logger;

@Singleton
public class CacheMemcachedImpl
implements Cache {
    private final Logger logger;
    private final MemcachedClient client;
    private final SerializingTranscoder tc;
    private final NinjaProperties ninjaProperties;

    @Inject
    public CacheMemcachedImpl(final Logger logger, NinjaProperties ninjaProperties) throws Exception {
        this.logger = logger;
        this.ninjaProperties = ninjaProperties;
        this.tc = new SerializingTranscoder(){

            protected Object deserialize(byte[] data) {
                try {
                    return new ObjectInputStream(new ByteArrayInputStream(data)){

                        @Override
                        protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
                            return Class.forName(desc.getName(), false, Thread.currentThread().getContextClassLoader());
                        }
                    }.readObject();
                }
                catch (Exception e) {
                    logger.error("Could not deserialize", (Throwable)e);
                    return null;
                }
            }

            protected byte[] serialize(Object object) {
                try {
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    new ObjectOutputStream(bos).writeObject(object);
                    return bos.toByteArray();
                }
                catch (IOException e) {
                    logger.error("Could not serialize", (Throwable)e);
                    return null;
                }
            }
        };
        System.setProperty("net.spy.log.LoggerImpl", "net.spy.memcached.compat.log.Log4JLogger");
        String allMemcachedHosts = ninjaProperties.getOrDie("memcached.host");
        List addrs = AddrUtil.getAddresses((String)allMemcachedHosts);
        String memcachedUser = ninjaProperties.get("memcached.user");
        if (memcachedUser != null) {
            String memcachePassword = ninjaProperties.getOrDie("memcached.password");
            AuthDescriptor ad = new AuthDescriptor(new String[]{"PLAIN"}, (CallbackHandler)new PlainCallbackHandler(memcachedUser, memcachePassword));
            ConnectionFactory cf = new ConnectionFactoryBuilder().setProtocol(ConnectionFactoryBuilder.Protocol.BINARY).setAuthDescriptor(ad).build();
            this.client = new MemcachedClient(cf, addrs);
        } else {
            this.client = new MemcachedClient(addrs);
        }
    }

    @Override
    public void add(String key, Object value, int expiration) {
        this.client.add(key, expiration, value, (Transcoder)this.tc);
    }

    @Override
    public Object get(String key) {
        GetFuture future = this.client.asyncGet(key, (Transcoder)this.tc);
        try {
            return future.get(1L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            future.cancel(false);
            return null;
        }
    }

    @Override
    public void clear() {
        this.client.flush();
    }

    @Override
    public void delete(String key) {
        this.client.delete(key);
    }

    @Override
    public Map<String, Object> get(String[] keys) {
        BulkFuture future = this.client.asyncGetBulk((Transcoder)this.tc, keys);
        try {
            return (Map)future.get(1L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            future.cancel(false);
            return Collections.emptyMap();
        }
    }

    @Override
    public long incr(String key, int by) {
        return this.client.incr(key, by, 0L);
    }

    @Override
    public long decr(String key, int by) {
        return this.client.decr(key, by, 0L);
    }

    @Override
    public void replace(String key, Object value, int expiration) {
        this.client.replace(key, expiration, value, (Transcoder)this.tc);
    }

    @Override
    public boolean safeAdd(String key, Object value, int expiration) {
        OperationFuture future = this.client.add(key, expiration, value, (Transcoder)this.tc);
        try {
            return (Boolean)future.get(1L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            future.cancel(false);
            return false;
        }
    }

    @Override
    public boolean safeDelete(String key) {
        OperationFuture future = this.client.delete(key);
        try {
            return (Boolean)future.get(1L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            future.cancel(false);
            return false;
        }
    }

    @Override
    public boolean safeReplace(String key, Object value, int expiration) {
        OperationFuture future = this.client.replace(key, expiration, value, (Transcoder)this.tc);
        try {
            return (Boolean)future.get(1L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            future.cancel(false);
            return false;
        }
    }

    @Override
    public boolean safeSet(String key, Object value, int expiration) {
        OperationFuture future = this.client.set(key, expiration, value, (Transcoder)this.tc);
        try {
            return (Boolean)future.get(1L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            future.cancel(false);
            return false;
        }
    }

    @Override
    public void set(String key, Object value, int expiration) {
        this.client.set(key, expiration, value, (Transcoder)this.tc);
    }

    @Dispose
    public void stop() {
        this.client.shutdown();
    }
}

