/*
 * Decompiled with CFR 0.152.
 */
package ninja.cache;

import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import ninja.cache.Cache;
import ninja.cache.CacheEhCacheImpl;
import ninja.utils.NinjaProperties;
import org.slf4j.Logger;

@Singleton
public class CacheProvider
implements Provider<Cache> {
    private final NinjaProperties ninjaProperties;
    private final Injector injector;
    private final Cache cache;
    private final Logger logger;

    @Inject
    public CacheProvider(Injector injector, NinjaProperties ninjaProperties, Logger logger) {
        this.ninjaProperties = ninjaProperties;
        this.injector = injector;
        this.logger = logger;
        Class cacheClass = null;
        String cacheImplClassName = ninjaProperties.get("cache.implementation");
        if (cacheImplClassName != null) {
            try {
                Class<?> clazz = Class.forName(cacheImplClassName);
                cacheClass = clazz.asSubclass(Cache.class);
                logger.info("Using the {} as implementation for caching.", cacheClass);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Class defined in configuration cache.implementationnot found (" + cacheClass + ")", e);
            }
            catch (ClassCastException e) {
                throw new RuntimeException("Class defined in configuration cache.implementationis not an instance of interface cache (" + cacheClass + ")", e);
            }
        }
        if (cacheClass == null) {
            cacheClass = CacheEhCacheImpl.class;
            logger.info("Using default eh cache implementation. ({}) ", cacheClass);
        }
        this.cache = (Cache)injector.getInstance(cacheClass);
    }

    public Cache get() {
        return this.cache;
    }
}

