/*
 * Decompiled with CFR 0.152.
 */
package ninja.i18n;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import ninja.Context;
import ninja.Result;
import ninja.i18n.Lang;
import ninja.i18n.Messages;
import ninja.utils.NinjaProperties;
import ninja.utils.SwissKnife;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationConverter;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.configuration.reloading.FileChangedReloadingStrategy;
import org.apache.commons.configuration.reloading.ReloadingStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class MessagesImpl
implements Messages {
    private static Logger logger = LoggerFactory.getLogger(MessagesImpl.class);
    private final Map<String, Configuration> langToKeyAndValuesMapping;
    private final NinjaProperties ninjaProperties;
    private final Lang lang;

    @Inject
    public MessagesImpl(NinjaProperties ninjaProperties, Lang lang) {
        this.ninjaProperties = ninjaProperties;
        this.lang = lang;
        this.langToKeyAndValuesMapping = this.loadAllMessageFilesForRegisteredLanguages();
    }

    @Override
    public Optional<String> get(String key, Context context, Optional<Result> result, Object ... parameter) {
        Optional<String> language = this.lang.getLanguage(context, result);
        return this.get(key, language, parameter);
    }

    @Override
    public Optional<String> get(String key, Optional<String> language, Object ... params) {
        Configuration configuration = this.getLanguageConfigurationForLocale(language);
        String value = configuration.getString(key);
        if (value != null) {
            MessageFormat messageFormat = this.getMessageFormatForLocale(value, language);
            return Optional.of((Object)messageFormat.format(params));
        }
        return Optional.absent();
    }

    @Override
    public Map<Object, Object> getAll(Context context, Optional<Result> result) {
        Optional<String> language = this.lang.getLanguage(context, result);
        return this.getAll(language);
    }

    @Override
    public Map<Object, Object> getAll(Optional<String> language) {
        Configuration configuration = this.getLanguageConfigurationForLocale(language);
        return ConfigurationConverter.getMap((Configuration)configuration);
    }

    @Override
    public String getWithDefault(String key, String defaultMessage, Context context, Optional<Result> result, Object ... params) {
        Optional<String> language = this.lang.getLanguage(context, result);
        return this.getWithDefault(key, defaultMessage, language, params);
    }

    @Override
    public String getWithDefault(String key, String defaultMessage, Optional<String> language, Object ... params) {
        Optional<String> value = this.get(key, language, params);
        if (value.isPresent()) {
            return (String)value.get();
        }
        MessageFormat messageFormat = this.getMessageFormatForLocale(defaultMessage, language);
        return messageFormat.format(params);
    }

    private PropertiesConfiguration loadLanguageConfiguration(String fileOrUrl) {
        PropertiesConfiguration configuration = SwissKnife.loadConfigurationInUtf8(fileOrUrl);
        if (configuration != null && this.ninjaProperties.isDev()) {
            FileChangedReloadingStrategy strategy = new FileChangedReloadingStrategy();
            configuration.setReloadingStrategy((ReloadingStrategy)strategy);
        }
        return configuration;
    }

    private Map<String, Configuration> loadAllMessageFilesForRegisteredLanguages() {
        HashMap langToKeyAndValuesMappingMutable = Maps.newHashMap();
        PropertiesConfiguration defaultLanguage = this.loadLanguageConfiguration("conf/messages.properties");
        if (defaultLanguage == null) {
            throw new RuntimeException("Did not find conf/messages.properties. Please add a default language file.");
        }
        langToKeyAndValuesMappingMutable.put("", defaultLanguage);
        String[] applicationLangs = this.ninjaProperties.getStringArray("application.languages");
        if (applicationLangs == null) {
            return ImmutableMap.copyOf((Map)langToKeyAndValuesMappingMutable);
        }
        for (String lang : applicationLangs) {
            PropertiesConfiguration configuration = this.loadLanguageConfiguration(String.format("conf/messages_%s.properties", lang));
            PropertiesConfiguration configurationLangOnly = null;
            if (lang.contains("-")) {
                String langOnly = lang.split("-")[0];
                configurationLangOnly = this.loadLanguageConfiguration(String.format("conf/messages_%s.properties", langOnly));
            }
            if (configuration == null) {
                logger.info("Did not find conf/messages_{}.properties but it was specified in application.conf. Using default language instead.", (Object)lang);
                continue;
            }
            CompositeConfiguration compositeConfiguration = new CompositeConfiguration();
            compositeConfiguration.addConfiguration((Configuration)configuration);
            if (configurationLangOnly != null) {
                compositeConfiguration.addConfiguration(configurationLangOnly);
            }
            compositeConfiguration.addConfiguration((Configuration)defaultLanguage);
            langToKeyAndValuesMappingMutable.put(lang, compositeConfiguration);
        }
        return ImmutableMap.copyOf((Map)langToKeyAndValuesMappingMutable);
    }

    private Configuration getLanguageConfigurationForLocale(Optional<String> language) {
        String[] languages;
        if (!language.isPresent()) {
            return this.langToKeyAndValuesMapping.get("");
        }
        for (String l : languages = ((String)language.get()).split(",")) {
            Configuration configuration;
            if ((l = l.trim()).contains(";")) {
                l = l.split(";")[0];
            }
            if ((configuration = this.langToKeyAndValuesMapping.get(l)) != null) {
                return configuration;
            }
            if (!l.contains("-")) continue;
            String[] array = l.split("-");
            String languageWithoutCountry = array[0];
            if (array.length > 1) {
                String country = array[1];
                String languageWithUpperCaseCountry = languageWithoutCountry + "-" + country.toUpperCase();
                configuration = this.langToKeyAndValuesMapping.get(languageWithUpperCaseCountry);
                if (configuration != null) {
                    return configuration;
                }
            }
            if ((configuration = this.langToKeyAndValuesMapping.get(languageWithoutCountry)) == null) continue;
            return configuration;
        }
        return this.langToKeyAndValuesMapping.get("");
    }

    MessageFormat getMessageFormatForLocale(String value, Optional<String> language) {
        Locale locale = this.lang.getLocaleFromStringOrDefault(language);
        MessageFormat messageFormat = new MessageFormat(value, locale);
        return messageFormat;
    }
}

