/*
 * Decompiled with CFR 0.152.
 */
package ninja.jpa;

import com.google.inject.AbstractModule;
import com.google.inject.Module;
import com.google.inject.matcher.Matchers;
import com.google.inject.persist.jpa.JpaPersistModule;
import java.util.Map;
import java.util.Properties;
import ninja.jpa.JpaInitializer;
import ninja.jpa.UnitOfWork;
import ninja.jpa.UnitOfWorkInterceptor;
import ninja.utils.NinjaProperties;
import org.aopalliance.intercept.MethodInterceptor;

public class JpaModule
extends AbstractModule {
    NinjaProperties ninjaProperties;

    public JpaModule(NinjaProperties ninjaProperties) {
        this.ninjaProperties = ninjaProperties;
    }

    protected void configure() {
        String persistenceUnitName = this.ninjaProperties.get("ninja.jpa.persistence_unit_name");
        if (persistenceUnitName != null) {
            String connectionUrl = this.ninjaProperties.get("db.connection.url");
            String connectionUsername = this.ninjaProperties.get("db.connection.username");
            String connectionPassword = this.ninjaProperties.get("db.connection.password");
            Properties jpaProperties = new Properties();
            if (connectionUrl != null) {
                jpaProperties.put("hibernate.connection.url", connectionUrl);
            }
            if (connectionUsername != null) {
                jpaProperties.put("hibernate.connection.username", connectionUsername);
            }
            if (connectionPassword != null) {
                jpaProperties.put("hibernate.connection.password", connectionPassword);
            }
            this.install((Module)new JpaPersistModule(persistenceUnitName).properties((Map)jpaProperties));
            UnitOfWorkInterceptor unitOfWorkInterceptor = new UnitOfWorkInterceptor();
            this.requestInjection(unitOfWorkInterceptor);
            this.bindInterceptor(Matchers.annotatedWith(UnitOfWork.class), Matchers.any(), new MethodInterceptor[]{unitOfWorkInterceptor});
            this.bindInterceptor(Matchers.any(), Matchers.annotatedWith(UnitOfWork.class), new MethodInterceptor[]{unitOfWorkInterceptor});
            this.bind(JpaInitializer.class).asEagerSingleton();
        }
    }
}

