/*
 * Decompiled with CFR 0.152.
 */
package ninja.jpa;

import com.google.inject.Inject;
import com.google.inject.persist.UnitOfWork;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

public class UnitOfWorkInterceptor
implements MethodInterceptor {
    @Inject
    UnitOfWork unitOfWork;
    final ThreadLocal<Boolean> didWeStartWork = new ThreadLocal();

    public Object invoke(MethodInvocation invocation) throws Throwable {
        if (null != this.didWeStartWork.get()) {
            return invocation.proceed();
        }
        this.unitOfWork.begin();
        this.didWeStartWork.set(Boolean.TRUE);
        try {
            Object object = invocation.proceed();
            return object;
        }
        finally {
            if (null != this.didWeStartWork.get()) {
                this.didWeStartWork.remove();
                this.unitOfWork.end();
            }
        }
    }
}

