/*
 * Decompiled with CFR 0.152.
 */
package ninja.lifecycle;

import com.google.inject.Binding;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Provider;
import com.google.inject.Scope;
import com.google.inject.Scopes;
import com.google.inject.internal.ProviderMethod;
import com.google.inject.spi.BindingScopingVisitor;
import com.google.inject.spi.DefaultBindingScopingVisitor;
import com.google.inject.spi.ProviderInstanceBinding;
import ninja.lifecycle.LifecycleRegister;
import ninja.lifecycle.LifecycleService;
import ninja.lifecycle.LifecycleSupport;
import ninja.lifecycle.State;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LifecycleServiceImpl
implements LifecycleService {
    private static final Logger log = LoggerFactory.getLogger(LifecycleServiceImpl.class);
    private final Injector injector;
    private final LifecycleRegister lifecycleRegister;
    private final LifecycleSupport lifecycleSupport;
    private volatile State state = State.STOPPED;
    private volatile long startTime;

    @Inject
    public LifecycleServiceImpl(Injector injector, LifecycleRegister lifecycleRegister, LifecycleSupport lifecycleSupport) {
        this.lifecycleRegister = lifecycleRegister;
        this.injector = injector;
        this.lifecycleSupport = lifecycleSupport;
    }

    @Override
    public void start() {
        this.startTime = System.currentTimeMillis();
        log.info("Starting Ninja application...");
        this.state = State.STARTING;
        for (final Binding binding : this.injector.getBindings().values()) {
            binding.acceptScopingVisitor((BindingScopingVisitor)new DefaultBindingScopingVisitor(){

                public Object visitEagerSingleton() {
                    LifecycleServiceImpl.this.injector.getInstance(binding.getKey());
                    return null;
                }

                public Object visitScope(Scope scope) {
                    if (scope.equals(Scopes.SINGLETON)) {
                        Provider providerInstance;
                        Object target = LifecycleServiceImpl.this.injector.getInstance(binding.getKey());
                        if (binding instanceof ProviderInstanceBinding && (providerInstance = ((ProviderInstanceBinding)binding).getProviderInstance()) instanceof ProviderMethod && LifecycleServiceImpl.this.lifecycleSupport.hasLifecycleMethod(target.getClass())) {
                            LifecycleServiceImpl.this.lifecycleSupport.registerLifecycle(target);
                        }
                    }
                    return null;
                }
            });
        }
        this.lifecycleRegister.start();
        long time = System.currentTimeMillis() - this.startTime;
        log.info("Ninja application started in {}ms", (Object)time);
        this.state = this.lifecycleRegister.isStarted() ? State.STARTED : State.STOPPED;
    }

    @Override
    public void stop() {
        long start = System.currentTimeMillis();
        log.info("Stopping Ninja application...");
        this.state = State.STOPPING;
        this.lifecycleRegister.stop();
        long time = System.currentTimeMillis() - start;
        log.info("Ninja application stopped in {}ms", (Object)time);
        this.state = this.lifecycleRegister.isStarted() ? State.STARTED : State.STOPPED;
    }

    @Override
    public boolean isStarted() {
        return this.lifecycleRegister.isStarted();
    }

    @Override
    public State getState() {
        return this.state;
    }

    @Override
    public long getUpTime() {
        if (this.isStarted()) {
            return System.currentTimeMillis() - this.startTime;
        }
        return 0L;
    }
}

