/*
 * Decompiled with CFR 0.152.
 */
package ninja.logging;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.util.StatusPrinter;
import com.google.common.io.Resources;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import ninja.utils.NinjaProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogbackConfigurator {
    public static final String LOGBACK_CONFIGURATION_FILE_PROPERTY = "logback.configurationFile";
    private static final Logger logger = LoggerFactory.getLogger(LogbackConfigurator.class);

    public static void initConfiguration(NinjaProperties ninjaProperties) {
        if (System.getProperty(LOGBACK_CONFIGURATION_FILE_PROPERTY) != null) {
            return;
        }
        String logbackConfigurationFile = ninjaProperties.get(LOGBACK_CONFIGURATION_FILE_PROPERTY);
        if (logbackConfigurationFile == null) {
            return;
        }
        URL logbackConfigurationFileAsURL = LogbackConfigurator.getUrlForStringFromClasspathAsFileOrUrl(logbackConfigurationFile);
        if (logbackConfigurationFileAsURL == null) {
            logger.error("Cannot configure logger from {} provided in application.conf", (Object)logbackConfigurationFile);
            return;
        }
        LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
        try {
            JoranConfigurator configurator = new JoranConfigurator();
            configurator.setContext((Context)context);
            context.reset();
            configurator.doConfigure(logbackConfigurationFileAsURL);
        }
        catch (JoranException je) {
            // empty catch block
        }
        logger.info("Successfully configured application logging from: {}", (Object)logbackConfigurationFileAsURL);
        StatusPrinter.printInCaseOfErrorsOrWarnings((Context)context);
    }

    protected static URL getUrlForStringFromClasspathAsFileOrUrl(String logbackConfigurationFile) {
        URL url = null;
        try {
            url = Resources.getResource((String)logbackConfigurationFile);
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        if (url == null) {
            try {
                File file = new File(logbackConfigurationFile);
                if (file.exists()) {
                    url = new File(logbackConfigurationFile).toURI().toURL();
                }
            }
            catch (MalformedURLException ex) {
                // empty catch block
            }
        }
        if (url == null) {
            try {
                url = new URL(logbackConfigurationFile);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return url;
    }
}

