/*
 * Decompiled with CFR 0.152.
 */
package ninja.params;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.lang.reflect.Array;
import java.util.Map;
import ninja.params.ParamParser;
import ninja.validation.ConstraintViolation;
import ninja.validation.Validation;

public class ParamParsers {
    private static final Map<Class<?>, ParamParser<?>> PARAM_PARSERS = ImmutableMap.builder().put(Integer.class, (Object)new IntegerParamParser()).put(Integer.TYPE, (Object)new PrimitiveIntegerParamParser()).put(Boolean.class, (Object)new BooleanParamParser()).put(Boolean.TYPE, (Object)new PrimitiveBooleanParamParser()).put(Long.class, (Object)new LongParamParser()).put(Long.TYPE, (Object)new PrimitiveLongParamParser()).put(Float.class, (Object)new FloatParamParser()).put(Float.TYPE, (Object)new PrimitiveFloatParamParser()).put(Double.class, (Object)new DoubleParamParser()).put(Double.TYPE, (Object)new PrimitiveDoubleParamParser()).put(String.class, (Object)new StringParamParser()).put(Byte.class, (Object)new ByteParamParser()).put(Byte.TYPE, (Object)new PrimitiveByteParamParser()).put(Short.class, (Object)new ShortParamParser()).put(Short.TYPE, (Object)new PrimitiveShortParamParser()).put(Character.class, (Object)new CharacterParamParser()).put(Character.TYPE, (Object)new PrimitiveCharacterParamParser()).build();
    private static final Map<Class<? extends Enum<?>>, ParamParser<?>> ENUM_PARSERS = Maps.newHashMap();

    public static ParamParser<?> getParamParser(Class<?> targetType) {
        Class<?> componentType;
        ParamParser<?> componentParser;
        if (targetType.isArray() && (componentParser = ParamParsers.getParamParser(componentType = targetType.getComponentType())) != null) {
            return new CsvParamParser(targetType, componentParser);
        }
        if (ENUM_PARSERS.containsKey(targetType)) {
            return ENUM_PARSERS.get(targetType);
        }
        return PARAM_PARSERS.get(targetType);
    }

    public static <E extends Enum<E>> void unregisterEnum(Class<E> enumClass) {
        ENUM_PARSERS.remove(enumClass);
    }

    public static <E extends Enum<E>> void registerEnum(Class<E> enumClass) {
        ParamParsers.registerEnum(enumClass, true);
    }

    public static <E extends Enum<E>> void registerEnum(final Class<E> enumClass, final boolean caseSensitive) {
        EnumParamParser parser = new EnumParamParser<E>(){

            @Override
            public Class<E> getParsedType() {
                return enumClass;
            }

            @Override
            protected boolean isCaseSensitive() {
                return caseSensitive;
            }
        };
        ENUM_PARSERS.put(enumClass, parser);
    }

    public static ArrayParamParser<?> getArrayParser(Class<?> targetType) {
        Class<?> componentType;
        ParamParser<?> componentParser;
        if (targetType.isArray() && (componentParser = ParamParsers.getParamParser(componentType = targetType.getComponentType())) != null) {
            return new ArrayParamParser(targetType, componentParser);
        }
        return null;
    }

    public static class ArrayParamParser<T> {
        private final Class<T[]> arrayType;
        private final ParamParser<T> itemParser;

        public ArrayParamParser(Class<T[]> arrayType, ParamParser<T> parser) {
            this.arrayType = arrayType;
            this.itemParser = parser;
        }

        public T[] parseParameter(String field, String[] parameterValues, Validation validation) {
            if (parameterValues == null || validation.hasFieldViolation(field)) {
                return null;
            }
            Class<T> itemType = this.getItemType();
            Object[] array = (Object[])Array.newInstance(itemType, parameterValues.length);
            for (int i = 0; i < parameterValues.length; ++i) {
                T t = this.itemParser.parseParameter(field, parameterValues[i], validation);
                Array.set(array, i, t);
            }
            if (validation.hasFieldViolation(field)) {
                return null;
            }
            return array;
        }

        public Class<T[]> getArrayType() {
            return this.arrayType;
        }

        public Class<T> getItemType() {
            return this.arrayType.getComponentType();
        }
    }

    public static class CsvParamParser<T>
    implements ParamParser<T[]> {
        private final Class<T[]> arrayType;
        private final ParamParser<T> itemParser;

        public CsvParamParser(Class<T[]> arrayType, ParamParser<T> parser) {
            this.arrayType = arrayType;
            this.itemParser = parser;
        }

        @Override
        public T[] parseParameter(String field, String parameterValue, Validation validation) {
            if (parameterValue == null || parameterValue.isEmpty() || validation.hasFieldViolation(field)) {
                return null;
            }
            String[] values = parameterValue.split(",(?=([^\"]*\"[^\"]*\")*[^\"]*$)");
            Class<?> itemType = this.arrayType.getComponentType();
            Object[] array = (Object[])Array.newInstance(itemType, values.length);
            for (int i = 0; i < values.length; ++i) {
                T t = this.itemParser.parseParameter(field, values[i], validation);
                Array.set(array, i, t);
            }
            if (validation.hasFieldViolation(field)) {
                return null;
            }
            return array;
        }

        @Override
        public Class<T[]> getParsedType() {
            return this.arrayType;
        }
    }

    public static abstract class EnumParamParser<E extends Enum<E>>
    implements ParamParser<E> {
        @Override
        public E parseParameter(String field, String parameterValue, Validation validation) {
            Enum[] values;
            if (parameterValue == null || validation.hasFieldViolation(field)) {
                return null;
            }
            boolean caseSensitive = this.isCaseSensitive();
            for (Enum value : values = (Enum[])this.getParsedType().getEnumConstants()) {
                if (!(caseSensitive ? value.name().equals(parameterValue) : value.name().equalsIgnoreCase(parameterValue))) continue;
                return (E)value;
            }
            validation.addFieldViolation(field, ConstraintViolation.createForFieldWithDefault("validation.is.enum.violation", field, "{0} is not a valid enum constant", parameterValue, this.getParsedType().getName()));
            return null;
        }

        @Override
        public abstract Class<E> getParsedType();

        protected abstract boolean isCaseSensitive();
    }

    public static class PrimitiveCharacterParamParser
    implements ParamParser<Character> {
        @Override
        public Character parseParameter(String field, String parameterValue, Validation validation) {
            if (parameterValue == null || parameterValue.isEmpty() || validation.hasFieldViolation(field)) {
                return Character.valueOf('\u0000');
            }
            return Character.valueOf(parameterValue.charAt(0));
        }

        @Override
        public Class<Character> getParsedType() {
            return Character.class;
        }
    }

    public static class CharacterParamParser
    implements ParamParser<Character> {
        @Override
        public Character parseParameter(String field, String parameterValue, Validation validation) {
            if (parameterValue == null || parameterValue.isEmpty() || validation.hasFieldViolation(field)) {
                return null;
            }
            return Character.valueOf(parameterValue.charAt(0));
        }

        @Override
        public Class<Character> getParsedType() {
            return Character.class;
        }
    }

    public static class PrimitiveShortParamParser
    implements ParamParser<Short> {
        @Override
        public Short parseParameter(String field, String parameterValue, Validation validation) {
            if (parameterValue == null || validation.hasFieldViolation(field)) {
                return (short)0;
            }
            try {
                return Short.parseShort(parameterValue);
            }
            catch (NumberFormatException e) {
                validation.addFieldViolation(field, ConstraintViolation.createForFieldWithDefault("validation.is.integer.violation", field, "{0} must be an integer", parameterValue));
                return (short)0;
            }
        }

        @Override
        public Class<Short> getParsedType() {
            return Short.class;
        }
    }

    public static class ShortParamParser
    implements ParamParser<Short> {
        @Override
        public Short parseParameter(String field, String parameterValue, Validation validation) {
            if (parameterValue == null || validation.hasFieldViolation(field)) {
                return null;
            }
            try {
                return Short.parseShort(parameterValue);
            }
            catch (NumberFormatException e) {
                validation.addFieldViolation(field, ConstraintViolation.createForFieldWithDefault("validation.is.integer.violation", field, "{0} must be an integer", parameterValue));
                return null;
            }
        }

        @Override
        public Class<Short> getParsedType() {
            return Short.class;
        }
    }

    public static class PrimitiveByteParamParser
    implements ParamParser<Byte> {
        @Override
        public Byte parseParameter(String field, String parameterValue, Validation validation) {
            if (parameterValue == null || validation.hasFieldViolation(field)) {
                return (byte)0;
            }
            try {
                return Byte.parseByte(parameterValue);
            }
            catch (NumberFormatException e) {
                validation.addFieldViolation(field, ConstraintViolation.createForFieldWithDefault("validation.is.integer.violation", field, "{0} must be an integer", parameterValue));
                return (byte)0;
            }
        }

        @Override
        public Class<Byte> getParsedType() {
            return Byte.class;
        }
    }

    public static class ByteParamParser
    implements ParamParser<Byte> {
        @Override
        public Byte parseParameter(String field, String parameterValue, Validation validation) {
            if (parameterValue == null || validation.hasFieldViolation(field)) {
                return null;
            }
            try {
                return Byte.parseByte(parameterValue);
            }
            catch (NumberFormatException e) {
                validation.addFieldViolation(field, ConstraintViolation.createForFieldWithDefault("validation.is.integer.violation", field, "{0} must be an integer", parameterValue));
                return null;
            }
        }

        @Override
        public Class<Byte> getParsedType() {
            return Byte.class;
        }
    }

    public static class StringParamParser
    implements ParamParser<String> {
        @Override
        public String parseParameter(String field, String parameterValue, Validation validation) {
            if (parameterValue == null || validation.hasFieldViolation(field)) {
                return null;
            }
            return parameterValue;
        }

        @Override
        public Class<String> getParsedType() {
            return String.class;
        }
    }

    public static class PrimitiveDoubleParamParser
    implements ParamParser<Double> {
        @Override
        public Double parseParameter(String field, String parameterValue, Validation validation) {
            if (parameterValue == null || validation.hasFieldViolation(field)) {
                return 0.0;
            }
            try {
                return Double.parseDouble(parameterValue);
            }
            catch (NumberFormatException e) {
                validation.addFieldViolation(field, ConstraintViolation.createForFieldWithDefault("validation.is.float.violation", field, "{0} must be a decimal number", parameterValue));
                return 0.0;
            }
        }

        @Override
        public Class<Double> getParsedType() {
            return Double.class;
        }
    }

    public static class DoubleParamParser
    implements ParamParser<Double> {
        @Override
        public Double parseParameter(String field, String parameterValue, Validation validation) {
            if (parameterValue == null || validation.hasFieldViolation(field)) {
                return null;
            }
            try {
                return Double.parseDouble(parameterValue);
            }
            catch (NumberFormatException e) {
                validation.addFieldViolation(field, ConstraintViolation.createForFieldWithDefault("validation.is.float.violation", field, "{0} must be a decimal number", parameterValue));
                return null;
            }
        }

        @Override
        public Class<Double> getParsedType() {
            return Double.class;
        }
    }

    public static class PrimitiveFloatParamParser
    implements ParamParser<Float> {
        @Override
        public Float parseParameter(String field, String parameterValue, Validation validation) {
            if (parameterValue == null || validation.hasFieldViolation(field)) {
                return Float.valueOf(0.0f);
            }
            try {
                return Float.valueOf(Float.parseFloat(parameterValue));
            }
            catch (NumberFormatException e) {
                validation.addFieldViolation(field, ConstraintViolation.createForFieldWithDefault("validation.is.float.violation", field, "{0} must be a decimal number", parameterValue));
                return Float.valueOf(0.0f);
            }
        }

        @Override
        public Class<Float> getParsedType() {
            return Float.class;
        }
    }

    public static class FloatParamParser
    implements ParamParser<Float> {
        @Override
        public Float parseParameter(String field, String parameterValue, Validation validation) {
            if (parameterValue == null || validation.hasFieldViolation(field)) {
                return null;
            }
            try {
                return Float.valueOf(Float.parseFloat(parameterValue));
            }
            catch (NumberFormatException e) {
                validation.addFieldViolation(field, ConstraintViolation.createForFieldWithDefault("validation.is.float.violation", field, "{0} must be a decimal number", parameterValue));
                return null;
            }
        }

        @Override
        public Class<Float> getParsedType() {
            return Float.class;
        }
    }

    public static class PrimitiveLongParamParser
    implements ParamParser<Long> {
        @Override
        public Long parseParameter(String field, String parameterValue, Validation validation) {
            if (parameterValue == null || validation.hasFieldViolation(field)) {
                return 0L;
            }
            try {
                return Long.parseLong(parameterValue);
            }
            catch (NumberFormatException e) {
                validation.addFieldViolation(field, ConstraintViolation.createForFieldWithDefault("validation.is.integer.violation", field, "{0} must be an integer", parameterValue));
                return 0L;
            }
        }

        @Override
        public Class<Long> getParsedType() {
            return Long.class;
        }
    }

    public static class LongParamParser
    implements ParamParser<Long> {
        @Override
        public Long parseParameter(String field, String parameterValue, Validation validation) {
            if (parameterValue == null || validation.hasFieldViolation(field)) {
                return null;
            }
            try {
                return Long.parseLong(parameterValue);
            }
            catch (NumberFormatException e) {
                validation.addFieldViolation(field, ConstraintViolation.createForFieldWithDefault("validation.is.integer.violation", field, "{0} must be an integer", parameterValue));
                return null;
            }
        }

        @Override
        public Class<Long> getParsedType() {
            return Long.class;
        }
    }

    public static class PrimitiveBooleanParamParser
    implements ParamParser<Boolean> {
        @Override
        public Boolean parseParameter(String field, String parameterValue, Validation validation) {
            if (parameterValue == null || validation.hasFieldViolation(field)) {
                return false;
            }
            return Boolean.parseBoolean(parameterValue);
        }

        @Override
        public Class<Boolean> getParsedType() {
            return Boolean.class;
        }
    }

    public static class BooleanParamParser
    implements ParamParser<Boolean> {
        @Override
        public Boolean parseParameter(String field, String parameterValue, Validation validation) {
            if (parameterValue == null || validation.hasFieldViolation(field)) {
                return null;
            }
            return Boolean.parseBoolean(parameterValue);
        }

        @Override
        public Class<Boolean> getParsedType() {
            return Boolean.class;
        }
    }

    public static class IntegerParamParser
    implements ParamParser<Integer> {
        @Override
        public Integer parseParameter(String field, String parameterValue, Validation validation) {
            if (parameterValue == null || validation.hasFieldViolation(field)) {
                return null;
            }
            try {
                return Integer.parseInt(parameterValue);
            }
            catch (NumberFormatException e) {
                validation.addFieldViolation(field, ConstraintViolation.createForFieldWithDefault("validation.is.integer.violation", field, "{0} must be an integer", parameterValue));
                return null;
            }
        }

        @Override
        public Class<Integer> getParsedType() {
            return Integer.class;
        }
    }

    public static class PrimitiveIntegerParamParser
    implements ParamParser<Integer> {
        @Override
        public Integer parseParameter(String field, String parameterValue, Validation validation) {
            if (parameterValue == null || validation.hasFieldViolation(field)) {
                return 0;
            }
            try {
                return Integer.parseInt(parameterValue);
            }
            catch (NumberFormatException e) {
                validation.addFieldViolation(field, ConstraintViolation.createForFieldWithDefault("validation.is.integer.violation", field, "{0} must be an integer", parameterValue));
                return 0;
            }
        }

        @Override
        public Class<Integer> getParsedType() {
            return Integer.class;
        }
    }
}

