/*
 * Decompiled with CFR 0.152.
 */
package ninja.postoffice.commonsmail;

import com.google.inject.Inject;
import javax.mail.internet.AddressException;
import ninja.postoffice.Mail;
import ninja.postoffice.Postoffice;
import ninja.postoffice.commonsmail.CommonsmailHelper;
import ninja.utils.NinjaProperties;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.MultiPartEmail;

public class PostofficeCommonsmailImpl
implements Postoffice {
    private final CommonsmailHelper commonsmailHelper;
    private final String smtpHost;
    private final int smtpPort;
    private final boolean smtpSsl;
    private final String smtpUser;
    private final String smtpPassword;
    private final boolean smtpDebug;

    @Inject
    public PostofficeCommonsmailImpl(CommonsmailHelper commonsmailHelper, NinjaProperties props) {
        this.commonsmailHelper = commonsmailHelper;
        this.smtpHost = props.getOrDie("smtp.host");
        Integer smtpPort = props.getInteger("smtp.port");
        this.smtpPort = smtpPort == null ? 25 : smtpPort;
        Boolean smtpSsl = props.getBoolean("smtp.ssl");
        this.smtpSsl = smtpSsl == null ? false : smtpSsl;
        this.smtpUser = props.get("smtp.user");
        this.smtpPassword = props.get("smtp.password");
        Boolean smtpDebug = props.getBoolean("smtp.debug");
        this.smtpDebug = smtpDebug == null ? false : smtpDebug;
    }

    PostofficeCommonsmailImpl(CommonsmailHelper commonsmailHelper, String smtpHost, int smtpPort, boolean smtpSsl, String smtpUser, String smtpPassword, boolean smtpDebug) {
        this.commonsmailHelper = commonsmailHelper;
        this.smtpHost = smtpHost;
        this.smtpPort = smtpPort;
        this.smtpSsl = smtpSsl;
        this.smtpUser = smtpUser;
        this.smtpPassword = smtpPassword;
        this.smtpDebug = smtpDebug;
    }

    @Override
    public void send(Mail mail) throws EmailException, AddressException {
        MultiPartEmail multiPartEmail = this.commonsmailHelper.createMultiPartEmailWithContent(mail);
        this.commonsmailHelper.doPopulateMultipartMailWithContent(multiPartEmail, mail);
        this.commonsmailHelper.doSetServerParameter(multiPartEmail, this.smtpHost, this.smtpPort, this.smtpSsl, this.smtpUser, this.smtpPassword, this.smtpDebug);
        multiPartEmail.send();
    }
}

