/*
 * Decompiled with CFR 0.152.
 */
package ninja.scheduler;

import com.google.inject.AbstractModule;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import com.google.inject.matcher.Matchers;
import com.google.inject.spi.InjectionListener;
import com.google.inject.spi.TypeEncounter;
import com.google.inject.spi.TypeListener;
import ninja.scheduler.Scheduler;

public class SchedulerSupport {
    public static Module getModule() {
        return new SchedulerSupport().constructModule();
    }

    private SchedulerSupport() {
    }

    private Module constructModule() {
        return new AbstractModule(){

            protected void configure() {
                Scheduler scheduler = new Scheduler();
                this.requestInjection(scheduler);
                this.bindListener(Matchers.any(), new SchedulableListener(scheduler));
                this.bind(Scheduler.class).toInstance((Object)scheduler);
            }
        };
    }

    private static class ScheduleListener<I>
    implements InjectionListener<I> {
        private final Scheduler scheduler;

        private ScheduleListener(Scheduler scheduler) {
            this.scheduler = scheduler;
        }

        public void afterInjection(I injectee) {
            this.scheduler.schedule(injectee);
        }
    }

    private static class SchedulableListener
    implements TypeListener {
        private final Scheduler scheduler;

        private SchedulableListener(Scheduler scheduler) {
            this.scheduler = scheduler;
        }

        public <I> void hear(TypeLiteral<I> type, TypeEncounter<I> encounter) {
            if (this.scheduler.hasScheduledMethod(type.getRawType())) {
                encounter.register(new ScheduleListener(this.scheduler));
            }
        }
    }
}

