/*
 * Decompiled with CFR 0.152.
 */
package ninja.session;

import com.google.inject.Inject;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import ninja.Context;
import ninja.Cookie;
import ninja.session.FlashScope;
import ninja.utils.CookieDataCodec;
import ninja.utils.NinjaProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlashScopeImpl
implements FlashScope {
    private Map<String, String> currentFlashCookieData = new HashMap<String, String>();
    private Map<String, String> outgoingFlashCookieData = new HashMap<String, String>();
    private String applicationCookiePrefix;
    private static Logger logger = LoggerFactory.getLogger(FlashScopeImpl.class);

    @Inject
    public FlashScopeImpl(NinjaProperties ninjaProperties) {
        this.applicationCookiePrefix = ninjaProperties.getOrDie("application.cookie.prefix");
    }

    @Override
    public void init(Context context) {
        Cookie flashCookie = context.getCookie(this.applicationCookiePrefix + "_FLASH");
        if (flashCookie != null) {
            try {
                CookieDataCodec.decode(this.currentFlashCookieData, flashCookie.getValue());
            }
            catch (UnsupportedEncodingException e) {
                logger.error("Encoding exception - this must not happen", (Throwable)e);
            }
        }
    }

    @Override
    public void save(Context context) {
        if (this.outgoingFlashCookieData.isEmpty()) {
            if (context.hasCookie(this.applicationCookiePrefix + "_FLASH")) {
                Cookie.Builder cookie = Cookie.builder(this.applicationCookiePrefix + "_FLASH", "");
                cookie.setPath(context.getContextPath() + "/");
                cookie.setSecure(false);
                cookie.setMaxAge(0);
                context.addCookie(cookie.build());
            }
        } else {
            try {
                String flashData = CookieDataCodec.encode(this.outgoingFlashCookieData);
                Cookie.Builder cookie = Cookie.builder(this.applicationCookiePrefix + "_FLASH", flashData);
                cookie.setPath(context.getContextPath() + "/");
                cookie.setSecure(false);
                cookie.setMaxAge(-1);
                context.addCookie(cookie.build());
            }
            catch (Exception e) {
                logger.error("Encoding exception - this must not happen", (Throwable)e);
            }
        }
    }

    @Override
    public void put(String key, String value) {
        if (key.contains(":")) {
            throw new IllegalArgumentException("Character ':' is invalid in a flash key.");
        }
        this.currentFlashCookieData.put(key, value);
        this.outgoingFlashCookieData.put(key, value);
    }

    @Override
    public void put(String key, Object value) {
        if (value == null) {
            this.put(key, null);
        }
        this.put(key, value + "");
    }

    @Override
    public void now(String key, String value) {
        if (key.contains(":")) {
            throw new IllegalArgumentException("Character ':' is invalid in a flash key.");
        }
        this.currentFlashCookieData.put(key, value);
    }

    @Override
    public void error(String value) {
        this.put("error", value);
    }

    @Override
    public void success(String value) {
        this.put("success", value);
    }

    @Override
    public void discard(String key) {
        this.outgoingFlashCookieData.remove(key);
    }

    @Override
    public void discard() {
        this.outgoingFlashCookieData.clear();
    }

    @Override
    public void keep(String key) {
        if (this.currentFlashCookieData.containsKey(key)) {
            this.outgoingFlashCookieData.put(key, this.currentFlashCookieData.get(key));
        }
    }

    @Override
    public void keep() {
        this.outgoingFlashCookieData.putAll(this.currentFlashCookieData);
    }

    @Override
    public String get(String key) {
        return this.currentFlashCookieData.get(key);
    }

    @Override
    public boolean remove(String key) {
        return this.currentFlashCookieData.remove(key) != null;
    }

    @Override
    public void clearCurrentFlashCookieData() {
        this.currentFlashCookieData.clear();
    }

    @Override
    public boolean contains(String key) {
        return this.currentFlashCookieData.containsKey(key);
    }

    @Override
    public Map<String, String> getCurrentFlashCookieData() {
        return this.currentFlashCookieData;
    }

    @Override
    public Map<String, String> getOutgoingFlashCookieData() {
        return this.outgoingFlashCookieData;
    }
}

