/*
 * Decompiled with CFR 0.152.
 */
package ninja.session;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import ninja.Context;
import ninja.Cookie;
import ninja.session.Session;
import ninja.utils.Clock;
import ninja.utils.CookieDataCodec;
import ninja.utils.CookieEncryption;
import ninja.utils.Crypto;
import ninja.utils.NinjaProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionImpl
implements Session {
    private static final Logger logger = LoggerFactory.getLogger(SessionImpl.class);
    private final Crypto crypto;
    private final CookieEncryption encryption;
    private final Clock time;
    private Long sessionExpireTimeInMs;
    private final Long defaultSessionExpireTimeInMs;
    private final Boolean sessionSendOnlyIfChanged;
    private final Boolean sessionTransferredOverHttpsOnly;
    private final Boolean sessionHttpOnly;
    private final String applicationCookieDomain;
    private final Map<String, String> data = new HashMap<String, String>();
    private boolean sessionDataHasBeenChanged = false;
    private final String sessionCookieName;

    @Inject
    public SessionImpl(Crypto crypto, CookieEncryption encryption, NinjaProperties ninjaProperties, Clock clock) {
        this.crypto = crypto;
        this.encryption = encryption;
        this.time = clock;
        Integer sessionExpireTimeInSeconds = ninjaProperties.getInteger("application.session.expire_time_in_seconds");
        this.defaultSessionExpireTimeInMs = sessionExpireTimeInSeconds != null ? Long.valueOf((long)sessionExpireTimeInSeconds.intValue() * 1000L) : null;
        this.sessionExpireTimeInMs = this.defaultSessionExpireTimeInMs;
        this.sessionSendOnlyIfChanged = ninjaProperties.getBooleanWithDefault("application.session.send_only_if_changed", true);
        this.sessionTransferredOverHttpsOnly = ninjaProperties.getBooleanWithDefault("application.session.transferred_over_https_only", true);
        this.sessionHttpOnly = ninjaProperties.getBooleanWithDefault("application.session.http_only", true);
        this.applicationCookieDomain = ninjaProperties.get("application.cookie.domain");
        String applicationCookiePrefix = ninjaProperties.getOrDie("application.cookie.prefix");
        this.sessionCookieName = applicationCookiePrefix + "_SESSION";
    }

    @Override
    public void init(Context context) {
        try {
            Cookie cookie = context.getCookie(this.sessionCookieName);
            if (cookie != null && cookie.getValue() != null && !cookie.getValue().trim().isEmpty()) {
                Long expiryTime;
                String payload;
                String value = cookie.getValue();
                String sign = value.substring(0, value.indexOf("-"));
                if (CookieDataCodec.safeEquals(sign, this.crypto.signHmacSha1(payload = value.substring(value.indexOf("-") + 1)))) {
                    payload = this.encryption.decrypt(payload);
                    CookieDataCodec.decode(this.data, payload);
                }
                if (this.data.containsKey("___EP") && (expiryTime = Long.valueOf(Long.parseLong(this.data.get("___EP")))) >= 0L) {
                    this.sessionExpireTimeInMs = expiryTime;
                }
                this.checkExpire();
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            logger.error("Encoding exception - this must not happen", (Throwable)unsupportedEncodingException);
        }
    }

    protected boolean shouldExpire() {
        if (this.sessionExpireTimeInMs != null) {
            if (!this.data.containsKey("___TS")) {
                return true;
            }
            Long timestamp = Long.parseLong(this.data.get("___TS"));
            return timestamp + this.sessionExpireTimeInMs < this.time.currentTimeMillis();
        }
        return false;
    }

    @Override
    public void setExpiryTime(Long expiryTimeMs) {
        if (expiryTimeMs == null) {
            this.data.remove("___EP");
            this.sessionExpireTimeInMs = this.defaultSessionExpireTimeInMs;
            this.sessionDataHasBeenChanged = true;
        } else {
            this.data.put("___EP", "" + expiryTimeMs);
            this.sessionExpireTimeInMs = expiryTimeMs;
        }
        if (this.sessionExpireTimeInMs != null) {
            if (!this.data.containsKey("___TS")) {
                this.data.put("___TS", "" + this.time.currentTimeMillis());
            }
            this.checkExpire();
            this.sessionDataHasBeenChanged = true;
        }
    }

    private void checkExpire() {
        if (this.sessionExpireTimeInMs != null) {
            if (this.shouldExpire()) {
                this.sessionDataHasBeenChanged = true;
                this.data.clear();
            } else {
                this.data.put("___TS", "" + this.time.currentTimeMillis());
            }
        }
    }

    @Override
    public String getId() {
        if (!this.data.containsKey("___ID")) {
            this.put("___ID", UUID.randomUUID().toString());
        }
        return this.get("___ID");
    }

    @Override
    public Map<String, String> getData() {
        return ImmutableMap.copyOf(this.data);
    }

    @Override
    public String getAuthenticityToken() {
        if (!this.data.containsKey("___AT")) {
            this.put("___AT", UUID.randomUUID().toString());
        }
        return this.get("___AT");
    }

    @Override
    public void save(Context context) {
        if (!this.sessionDataHasBeenChanged && (this.sessionExpireTimeInMs == null || this.sessionSendOnlyIfChanged.booleanValue())) {
            return;
        }
        if (this.isEmpty()) {
            if (context.hasCookie(this.sessionCookieName)) {
                Cookie.Builder expiredSessionCookie = Cookie.builder(this.sessionCookieName, "");
                expiredSessionCookie.setPath(context.getContextPath() + "/");
                expiredSessionCookie.setMaxAge(0);
                context.addCookie(expiredSessionCookie.build());
            }
            return;
        }
        if (this.sessionExpireTimeInMs != null && !this.data.containsKey("___TS")) {
            this.data.put("___TS", Long.toString(System.currentTimeMillis()));
        }
        try {
            String sessionData = CookieDataCodec.encode(this.data);
            sessionData = this.encryption.encrypt(sessionData);
            String sign = this.crypto.signHmacSha1(sessionData);
            Cookie.Builder cookie = Cookie.builder(this.sessionCookieName, sign + "-" + sessionData);
            cookie.setPath(context.getContextPath() + "/");
            if (this.applicationCookieDomain != null) {
                cookie.setDomain(this.applicationCookieDomain);
            }
            if (this.sessionExpireTimeInMs != null) {
                cookie.setMaxAge((int)(this.sessionExpireTimeInMs / 1000L));
            }
            if (this.sessionTransferredOverHttpsOnly != null) {
                cookie.setSecure(this.sessionTransferredOverHttpsOnly);
            }
            if (this.sessionHttpOnly != null) {
                cookie.setHttpOnly(this.sessionHttpOnly);
            }
            context.addCookie(cookie.build());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            logger.error("Encoding exception - this must not happen", (Throwable)unsupportedEncodingException);
            throw new RuntimeException(unsupportedEncodingException);
        }
    }

    @Override
    public void put(String key, String value) {
        if (key.contains(":")) {
            throw new IllegalArgumentException("Character ':' is invalid in a session key.");
        }
        this.sessionDataHasBeenChanged = true;
        if (value == null) {
            this.remove(key);
        } else {
            this.data.put(key, value);
        }
    }

    @Override
    public String get(String key) {
        return this.data.get(key);
    }

    @Override
    public String remove(String key) {
        this.sessionDataHasBeenChanged = true;
        String result = this.get(key);
        this.data.remove(key);
        return result;
    }

    @Override
    public void clear() {
        this.sessionDataHasBeenChanged = true;
        this.data.clear();
    }

    @Override
    public boolean isEmpty() {
        int itemsToIgnore = 0;
        if (this.data.containsKey("___TS")) {
            ++itemsToIgnore;
        }
        if (this.data.containsKey("___EP")) {
            ++itemsToIgnore;
        }
        return this.data.isEmpty() || this.data.size() == itemsToIgnore;
    }
}

