/*
 * Decompiled with CFR 0.152.
 */
package ninja.template;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import freemarker.core.Environment;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import java.io.PrintWriter;
import java.io.Writer;
import ninja.utils.NinjaProperties;
import org.slf4j.Logger;

@Singleton
public class TemplateEngineFreemarkerExceptionHandler
implements TemplateExceptionHandler {
    private final NinjaProperties ninjaProperties;
    private final Logger logger;

    @Inject
    public TemplateEngineFreemarkerExceptionHandler(Logger logger, NinjaProperties ninjaProperties) {
        this.logger = logger;
        this.ninjaProperties = ninjaProperties;
    }

    public void handleTemplateException(TemplateException te, Environment env, Writer out) throws TemplateException {
        if (this.ninjaProperties.isProd()) {
            throw te;
        }
        PrintWriter pw = out instanceof PrintWriter ? (PrintWriter)out : new PrintWriter(out);
        pw.println("<!-- FREEMARKER ERROR MESSAGE STARTS HERE --><script language=javascript>//\"></script><script language=javascript>//'></script><script language=javascript>//\"></script><script language=javascript>//'></script></title></xmp></script></noscript></style></object></head></pre></table></form></table></table></table></a></u></i></b><div align=left style='background-color:#FFFF00; color:#FF0000; display:block; border-top:double; padding:2pt; font-size:medium; font-family:Arial,sans-serif; font-style: normal; font-variant: normal; font-weight: normal; text-decoration: none; text-transform: none'><b style='font-size:medium'>FreeMarker template error!</b><pre><xmp>");
        te.printStackTrace(pw);
        pw.println("</xmp></pre></div></html>");
        this.logger.error("Templating error.", (Throwable)te);
    }
}

