/*
 * Decompiled with CFR 0.152.
 */
package ninja.template;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.util.JSONPObject;
import com.google.common.base.Strings;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import java.io.OutputStream;
import java.util.regex.Pattern;
import ninja.Context;
import ninja.Result;
import ninja.template.TemplateEngine;
import ninja.utils.NinjaProperties;
import ninja.utils.ResponseStreams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class TemplateEngineJsonP
implements TemplateEngine {
    private final Logger logger = LoggerFactory.getLogger(TemplateEngineJsonP.class);
    static final String DEFAULT_CALLBACK_PARAMETER_NAME = "callback";
    static final String DEFAULT_CALLBACK_PARAMETER_VALUE = "onResponse";
    static final Pattern CALLBACK_SECURITY_VALIDATION_REGEXP = Pattern.compile("^([a-zA-Z$_]{1}[a-zA-Z0-9$_.]*[a-zA-Z0-9$_]{1}){1,}$");
    private final ObjectMapper objectMapper;
    private final String callbackParameterName;

    @Inject
    public TemplateEngineJsonP(ObjectMapper objectMapper, NinjaProperties properties) {
        this.objectMapper = objectMapper;
        this.callbackParameterName = properties.getWithDefault("ninja.jsonp.callbackParameter", DEFAULT_CALLBACK_PARAMETER_NAME);
    }

    @Override
    public void invoke(Context context, Result result) {
        ResponseStreams responseStreams = context.finalizeHeaders(result);
        String callback = this.getCallbackName(context);
        try (OutputStream outputStream = responseStreams.getOutputStream();){
            this.objectMapper.writeValue(outputStream, (Object)new JSONPObject(callback, result.getRenderable()));
        }
        catch (IOException e) {
            this.logger.error("Error while rendering jsonp.", (Throwable)e);
        }
    }

    @Override
    public String getContentType() {
        return "application/javascript";
    }

    @Override
    public String getSuffixOfTemplatingEngine() {
        return null;
    }

    private String getCallbackName(Context context) {
        String callback = context.getParameter(this.callbackParameterName, DEFAULT_CALLBACK_PARAMETER_VALUE);
        return TemplateEngineJsonP.isThisASecureCallbackName(callback) ? callback : DEFAULT_CALLBACK_PARAMETER_VALUE;
    }

    public static boolean isThisASecureCallbackName(String callback) {
        return !Strings.isNullOrEmpty((String)callback) && !callback.contains("..") && CALLBACK_SECURITY_VALIDATION_REGEXP.matcher(callback).matches();
    }
}

