/*
 * Decompiled with CFR 0.152.
 */
package ninja.template;

import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.google.inject.Inject;
import java.io.IOException;
import java.io.OutputStream;
import javax.inject.Singleton;
import ninja.Context;
import ninja.Result;
import ninja.template.TemplateEngine;
import ninja.utils.ResponseStreams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class TemplateEngineXml
implements TemplateEngine {
    private static final Logger logger = LoggerFactory.getLogger(TemplateEngineXml.class);
    private final XmlMapper xmlMapper;

    @Inject
    public TemplateEngineXml(XmlMapper xmlMapper) {
        this.xmlMapper = xmlMapper;
    }

    @Override
    public void invoke(Context context, Result result) {
        ResponseStreams responseStreams = context.finalizeHeaders(result);
        try (OutputStream outputStream = responseStreams.getOutputStream();){
            this.xmlMapper.writeValue(outputStream, result.getRenderable());
        }
        catch (IOException e) {
            logger.error("Error while rendering json", (Throwable)e);
        }
    }

    @Override
    public String getContentType() {
        return "application/xml";
    }

    @Override
    public String getSuffixOfTemplatingEngine() {
        return null;
    }
}

