/*
 * Decompiled with CFR 0.152.
 */
package ninja.uploads;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import ninja.uploads.FileItem;
import ninja.uploads.FileItemProvider;
import ninja.utils.NinjaProperties;
import org.apache.commons.fileupload.FileItemHeaders;
import org.apache.commons.fileupload.FileItemStream;

@Singleton
public class DiskFileItemProvider
implements FileItemProvider {
    private File tmpFolder;

    @Inject
    public DiskFileItemProvider(NinjaProperties ninjaProperties) {
        String tempName = ninjaProperties.get("uploads.temp_folder");
        if (tempName == null) {
            tempName = System.getProperty("java.io.tmpdir");
        }
        this.tmpFolder = new File(tempName);
        if (!this.tmpFolder.exists()) {
            this.tmpFolder.mkdirs();
        }
    }

    @Override
    public FileItem create(FileItemStream item) {
        File tmpFile = null;
        try (InputStream is = item.openStream();){
            tmpFile = File.createTempFile("nju", null, this.tmpFolder);
            Files.copy(is, tmpFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create temporary uploaded file on disk", e);
        }
        final String name = item.getName();
        final File file = tmpFile;
        final String contentType = item.getContentType();
        final FileItemHeaders headers = item.getHeaders();
        return new FileItem(){

            @Override
            public String getFileName() {
                return name;
            }

            @Override
            public InputStream getInputStream() {
                try {
                    return new FileInputStream(file);
                }
                catch (FileNotFoundException e) {
                    throw new RuntimeException("Failed to read temporary uploaded file from disk", e);
                }
            }

            @Override
            public File getFile() {
                return file;
            }

            @Override
            public String getContentType() {
                return contentType;
            }

            @Override
            public FileItemHeaders getHeaders() {
                return headers;
            }

            @Override
            public void cleanup() {
                try {
                    file.delete();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
    }
}

