/*
 * Decompiled with CFR 0.152.
 */
package ninja.uploads;

import com.google.common.io.ByteStreams;
import com.google.inject.Singleton;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import ninja.uploads.FileItem;
import ninja.uploads.FileItemProvider;
import org.apache.commons.fileupload.FileItemHeaders;
import org.apache.commons.fileupload.FileItemStream;

@Singleton
public class MemoryFileItemProvider
implements FileItemProvider {
    @Override
    public FileItem create(FileItemStream item) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            ByteStreams.copy((InputStream)item.openStream(), (OutputStream)outputStream);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create temporary uploaded file in memory", e);
        }
        final String name = item.getName();
        final byte[] bytes = outputStream.toByteArray();
        final String contentType = item.getContentType();
        final FileItemHeaders headers = item.getHeaders();
        return new FileItem(){

            @Override
            public String getFileName() {
                return name;
            }

            @Override
            public InputStream getInputStream() {
                return new ByteArrayInputStream(bytes);
            }

            @Override
            public File getFile() {
                throw new UnsupportedOperationException("Not supported in MemoryFileProvider");
            }

            @Override
            public String getContentType() {
                return contentType;
            }

            @Override
            public FileItemHeaders getHeaders() {
                return headers;
            }

            @Override
            public void cleanup() {
            }
        };
    }
}

