/*
 * Decompiled with CFR 0.152.
 */
package ninja.utils;

import com.google.inject.Inject;
import com.google.inject.Injector;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import ninja.Context;
import ninja.Cookie;
import ninja.Result;
import ninja.Route;
import ninja.bodyparser.BodyParserEngine;
import ninja.bodyparser.BodyParserEngineManager;
import ninja.session.FlashScope;
import ninja.session.Session;
import ninja.utils.HttpHeaderUtils;
import ninja.utils.NinjaProperties;
import ninja.utils.ResponseStreams;
import ninja.utils.SwissKnife;
import ninja.validation.Validation;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractContext
implements Context.Impl {
    private static final Logger logger = LoggerFactory.getLogger(AbstractContext.class);
    protected final BodyParserEngineManager bodyParserEngineManager;
    protected final FlashScope flashScope;
    protected final NinjaProperties ninjaProperties;
    protected final Session session;
    protected final Validation validation;
    protected final Injector injector;
    protected Route route;
    private String requestPath;
    private String contextPath;

    @Inject
    public AbstractContext(BodyParserEngineManager bodyParserEngineManager, FlashScope flashScope, NinjaProperties ninjaProperties, Session session, Validation validation, Injector injector) {
        this.bodyParserEngineManager = bodyParserEngineManager;
        this.flashScope = flashScope;
        this.ninjaProperties = ninjaProperties;
        this.session = session;
        this.validation = validation;
        this.injector = injector;
    }

    protected void init(String contextPath, String requestPath) {
        this.contextPath = contextPath;
        this.requestPath = requestPath;
        this.flashScope.init(this);
        this.session.init(this);
    }

    @Override
    public void setRoute(Route route) {
        this.route = route;
    }

    @Override
    public Route getRoute() {
        return this.route;
    }

    @Override
    public Validation getValidation() {
        return this.validation;
    }

    @Override
    @Deprecated
    public FlashScope getFlashCookie() {
        return this.flashScope;
    }

    @Override
    public FlashScope getFlashScope() {
        return this.flashScope;
    }

    @Override
    @Deprecated
    public Session getSessionCookie() {
        return this.session;
    }

    @Override
    public Session getSession() {
        return this.session;
    }

    @Override
    public String getContextPath() {
        return this.contextPath;
    }

    @Override
    public String getRequestPath() {
        return this.requestPath;
    }

    protected abstract String getRealRemoteAddr();

    @Override
    public String getRemoteAddr() {
        String forwardHeader;
        boolean isUsageOfXForwardedHeaderEnabled = this.ninjaProperties.getBooleanWithDefault("ninja.x_forwarded_for_enabled", false);
        if (isUsageOfXForwardedHeaderEnabled && (forwardHeader = this.getHeader("X-Forwarded-For")) != null) {
            if (forwardHeader.contains(",")) {
                forwardHeader = StringUtils.split((String)forwardHeader, (char)',')[0].trim();
            }
            try {
                InetAddress.getByName(forwardHeader);
                return forwardHeader;
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        return this.getRealRemoteAddr();
    }

    @Override
    public <T> T getAttribute(String name, Class<T> clazz) {
        return clazz.cast(this.getAttribute(name));
    }

    @Override
    public String getPathParameter(String key) {
        String encodedParameter = this.route.getPathParametersEncoded(this.getRequestPath()).get(key);
        if (encodedParameter == null) {
            return null;
        }
        return URI.create(encodedParameter).getPath();
    }

    @Override
    public String getPathParameterEncoded(String key) {
        return this.route.getPathParametersEncoded(this.getRequestPath()).get(key);
    }

    @Override
    public Integer getPathParameterAsInteger(String key) {
        String parameter = this.getPathParameter(key);
        try {
            return Integer.parseInt(parameter);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Override
    public String getParameter(String key, String defaultValue) {
        String parameter = this.getParameter(key);
        if (parameter == null) {
            parameter = defaultValue;
        }
        return parameter;
    }

    @Override
    public Integer getParameterAsInteger(String key) {
        return this.getParameterAsInteger(key, null);
    }

    @Override
    public Integer getParameterAsInteger(String key, Integer defaultValue) {
        String parameter = this.getParameter(key);
        try {
            return Integer.parseInt(parameter);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    @Override
    public <T> T getParameterAs(String key, Class<T> clazz) {
        return this.getParameterAs(key, clazz, null);
    }

    @Override
    public <T> T getParameterAs(String key, Class<T> clazz, T defaultValue) {
        String parameter = this.getParameter(key);
        try {
            return SwissKnife.convert(parameter, clazz);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    @Override
    public <T> T parseBody(Class<T> classOfT) {
        String rawContentType = this.getRequestContentType();
        if (rawContentType == null) {
            logger.debug("Not able to parse body because request did not send content type header at: {}", (Object)this.getRequestPath());
            return null;
        }
        String contentTypeOnly = HttpHeaderUtils.getContentTypeFromContentTypeAndCharacterSetting(rawContentType);
        BodyParserEngine bodyParserEngine = this.bodyParserEngineManager.getBodyParserEngineForContentType(contentTypeOnly);
        if (bodyParserEngine == null) {
            logger.debug("No BodyParserEngine found for Content-Type {} at route {}", (Object)"Content-Type", (Object)this.getRequestPath());
            return null;
        }
        return bodyParserEngine.invoke(this, classOfT);
    }

    @Override
    public String getCookieValue(String name) {
        Cookie cookie = this.getCookie(name);
        if (cookie == null) {
            return null;
        }
        return cookie.getValue();
    }

    @Override
    public void unsetCookie(Cookie cookie) {
        this.addCookie(Cookie.builder(cookie).setMaxAge(0).build());
    }

    @Override
    public void asyncRequestComplete() {
        this.returnResultAsync(null);
    }

    protected ResponseStreams finalizeHeaders(Result result, Boolean handleFlashAndSessionCookie) {
        if (handleFlashAndSessionCookie.booleanValue()) {
            this.flashScope.save(this);
            this.session.save(this);
        }
        for (Cookie cookie : result.getCookies()) {
            this.addCookie(cookie);
        }
        return null;
    }

    @Override
    public ResponseStreams finalizeHeadersWithoutFlashAndSessionCookie(Result result) {
        return this.finalizeHeaders(result, false);
    }

    @Override
    public ResponseStreams finalizeHeaders(Result result) {
        return this.finalizeHeaders(result, true);
    }

    @Override
    public String getAcceptContentType() {
        String contentType = this.getHeader("accept");
        if (contentType == null) {
            return "text/html";
        }
        if (contentType.contains("application/xhtml") || contentType.contains("text/html") || contentType.startsWith("*/*")) {
            return "text/html";
        }
        if (contentType.contains("application/xml") || contentType.contains("text/xml")) {
            return "application/xml";
        }
        if (contentType.contains("application/json") || contentType.contains("text/javascript")) {
            return "application/json";
        }
        if (contentType.contains("text/plain")) {
            return "text/plain";
        }
        if (contentType.contains("application/octet-stream")) {
            return "application/octet-stream";
        }
        if (contentType.endsWith("*/*")) {
            return "text/html";
        }
        return "text/html";
    }

    @Override
    public String getAcceptEncoding() {
        return this.getHeader("accept-encoding");
    }

    @Override
    public String getAcceptLanguage() {
        return this.getHeader("accept-language");
    }

    @Override
    public String getAcceptCharset() {
        return this.getHeader("accept-charset");
    }

    @Override
    public boolean isRequestJson() {
        String contentType = this.getRequestContentType();
        if (contentType == null || contentType.isEmpty()) {
            return false;
        }
        return contentType.startsWith("application/json");
    }

    @Override
    public boolean isRequestXml() {
        String contentType = this.getRequestContentType();
        if (contentType == null || contentType.isEmpty()) {
            return false;
        }
        return contentType.startsWith("application/xml");
    }
}

