/*
 * Decompiled with CFR 0.152.
 */
package ninja.utils;

import com.google.common.base.Optional;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.util.Objects;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import ninja.utils.NinjaProperties;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class CookieEncryption {
    public static final String ALGORITHM = "AES";
    private static final Logger logger = LoggerFactory.getLogger(CookieEncryption.class);
    private final Optional<SecretKeySpec> secretKeySpec;
    private final boolean encryptionEnabled;

    @Inject
    public CookieEncryption(NinjaProperties properties) {
        Optional secretKeySpec = Optional.absent();
        if (properties.getBooleanWithDefault("application.cookie.encryption", false).booleanValue()) {
            this.encryptionEnabled = true;
            String secret = properties.getOrDie("application.secret");
            try {
                int maxKeyLengthBits = Cipher.getMaxAllowedKeyLength(ALGORITHM);
                if (maxKeyLengthBits == Integer.MAX_VALUE) {
                    maxKeyLengthBits = 256;
                }
                secretKeySpec = Optional.of((Object)new SecretKeySpec(secret.getBytes(), 0, maxKeyLengthBits / 8, ALGORITHM));
                logger.info("Ninja session encryption is using {} / {} bit.", (Object)((SecretKeySpec)secretKeySpec.get()).getAlgorithm(), (Object)maxKeyLengthBits);
            }
            catch (Exception exception) {
                logger.error("Can not create class to encrypt cookie.", (Throwable)exception);
                throw new RuntimeException(exception);
            }
        } else {
            this.encryptionEnabled = false;
            secretKeySpec = Optional.absent();
        }
        this.secretKeySpec = secretKeySpec;
    }

    public String encrypt(String data) {
        Objects.requireNonNull(data, "Data to be encrypted");
        if (!this.encryptionEnabled) {
            return data;
        }
        try {
            Cipher cipher = Cipher.getInstance(ALGORITHM);
            cipher.init(1, (Key)this.secretKeySpec.get());
            byte[] encrypted = cipher.doFinal(data.getBytes(StandardCharsets.UTF_8));
            return Base64.encodeBase64URLSafeString((byte[])encrypted);
        }
        catch (InvalidKeyException ex) {
            logger.error(this.getHelperLogMessage(), (Throwable)ex);
            throw new RuntimeException(ex);
        }
        catch (GeneralSecurityException ex) {
            logger.error("Failed to encrypt data.", (Throwable)ex);
            throw new RuntimeException(ex);
        }
    }

    public String decrypt(String data) {
        Objects.requireNonNull(data, "Data to be decrypted");
        if (!this.encryptionEnabled) {
            return data;
        }
        byte[] decoded = Base64.decodeBase64((String)data);
        try {
            Cipher cipher = Cipher.getInstance(ALGORITHM);
            cipher.init(2, (Key)this.secretKeySpec.get());
            byte[] decrypted = cipher.doFinal(decoded);
            return new String(decrypted, StandardCharsets.UTF_8);
        }
        catch (InvalidKeyException ex) {
            logger.error(this.getHelperLogMessage(), (Throwable)ex);
            throw new RuntimeException(ex);
        }
        catch (GeneralSecurityException ex) {
            logger.error("Failed to decrypt data.", (Throwable)ex);
            throw new RuntimeException(ex);
        }
    }

    private String getHelperLogMessage() {
        StringBuilder sb = new StringBuilder();
        sb.append("Invalid key provided. Check if application secret is properly set.").append(System.lineSeparator());
        sb.append("You can remove '").append("application.secret").append("' key in configuration file ");
        sb.append("and restart application. Ninja will generate new key for you.");
        return sb.toString();
    }
}

