/*
 * Decompiled with CFR 0.152.
 */
package ninja.utils;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import ninja.utils.NinjaProperties;
import org.apache.commons.codec.binary.Hex;

@Singleton
public class Crypto {
    private final String applicationSecret;

    @Inject
    public Crypto(NinjaProperties ninjaProperties) {
        this.applicationSecret = ninjaProperties.getOrDie("application.secret");
    }

    public String signHmacSha1(String message) {
        return this.signHmacSha1(message, this.applicationSecret);
    }

    private String signHmacSha1(String value, String key) {
        try {
            byte[] keyBytes = key.getBytes();
            SecretKeySpec signingKey = new SecretKeySpec(keyBytes, "HmacSHA1");
            Mac mac = Mac.getInstance("HmacSHA1");
            mac.init(signingKey);
            byte[] rawHmac = mac.doFinal(value.getBytes());
            byte[] hexBytes = new Hex().encode(rawHmac);
            return new String(hexBytes, "UTF-8");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

