/*
 * Decompiled with CFR 0.152.
 */
package ninja.utils;

import java.util.Date;
import java.util.Locale;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class DateUtil {
    private static final DateTimeFormatter RFC1123_DATE_FORMAT = DateTimeFormat.forPattern((String)"EEE, dd MMM yyyy HH:mm:ss 'GMT'").withLocale(Locale.US).withZone(DateTimeZone.UTC);

    public static String formatForHttpHeader(Date date) {
        return RFC1123_DATE_FORMAT.print((ReadableInstant)new DateTime((Object)date));
    }

    public static String formatForHttpHeader(Long unixTime) {
        return RFC1123_DATE_FORMAT.print((ReadableInstant)new DateTime((Object)unixTime));
    }

    public static Date parseHttpDateFormat(String httpDateFormat) throws IllegalArgumentException {
        return DateUtil.parseHttpDateFormatToDateTime(httpDateFormat).toDate();
    }

    public static DateTime parseHttpDateFormatToDateTime(String httpDateFormat) throws IllegalArgumentException {
        return RFC1123_DATE_FORMAT.parseDateTime(httpDateFormat);
    }
}

