/*
 * Decompiled with CFR 0.152.
 */
package ninja.utils;

import com.google.common.base.Optional;
import com.google.inject.Inject;
import java.util.Date;
import ninja.Context;
import ninja.Result;
import ninja.utils.DateUtil;
import ninja.utils.HttpCacheToolkit;
import ninja.utils.NinjaProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpCacheToolkitImpl
implements HttpCacheToolkit {
    private static final Logger logger = LoggerFactory.getLogger(HttpCacheToolkitImpl.class);
    private final NinjaProperties ninjaProperties;

    @Inject
    public HttpCacheToolkitImpl(NinjaProperties ninjaProperties) {
        this.ninjaProperties = ninjaProperties;
    }

    @Override
    public boolean isModified(Optional<String> etag, Optional<Long> lastModified, Context context) {
        String browserEtag = context.getHeader("If-None-Match");
        if (browserEtag != null && etag.isPresent()) {
            return !browserEtag.equals(etag.get());
        }
        String ifModifiedSince = context.getHeader("If-Modified-Since");
        if (ifModifiedSince != null && lastModified.isPresent() && !ifModifiedSince.isEmpty()) {
            try {
                Date browserDate = DateUtil.parseHttpDateFormat(ifModifiedSince);
                if (browserDate.getTime() >= (Long)lastModified.get()) {
                    return false;
                }
            }
            catch (IllegalArgumentException ex) {
                logger.warn("Can't parse HTTP date", (Throwable)ex);
            }
            return true;
        }
        return true;
    }

    @Override
    public void addEtag(Context context, Result result, Long lastModified) {
        if (!this.ninjaProperties.isProd()) {
            result.addHeader("Cache-Control", "no-cache");
        } else {
            String maxAge = this.ninjaProperties.getWithDefault("http.cache_control", "3600");
            if (maxAge.equals("0")) {
                result.addHeader("Cache-Control", "no-cache");
            } else {
                result.addHeader("Cache-Control", "max-age=" + maxAge);
            }
        }
        String etag = null;
        boolean useEtag = this.ninjaProperties.getBooleanWithDefault("http.useETag", true);
        if (useEtag) {
            etag = "\"" + lastModified.toString() + "\"";
            result.addHeader("ETag", etag);
        }
        if (!this.isModified((Optional<String>)Optional.fromNullable(etag), (Optional<Long>)Optional.fromNullable((Object)lastModified), context)) {
            if (context.getMethod().toLowerCase().equals("get")) {
                result.status(304);
            }
        } else {
            result.addHeader("Last-Modified", DateUtil.formatForHttpHeader(lastModified));
        }
    }
}

