/*
 * Decompiled with CFR 0.152.
 */
package ninja.utils;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ninja.Context;
import ninja.utils.NinjaProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class MimeTypes {
    private final Logger logger = LoggerFactory.getLogger(MimeTypes.class);
    private final String PROPERTY_MIMETYPE_PREFIX = "mimetype.";
    private final String DEFAULT_MIMET_TYPE_LOCATIONS = "ninja/utils/mime-types.properties";
    private final Properties mimetypes;
    private final Pattern extPattern;
    private final NinjaProperties ninjaProperties;

    @Inject
    public MimeTypes(NinjaProperties ninjaProperties) {
        this.ninjaProperties = ninjaProperties;
        this.extPattern = Pattern.compile("^.*\\.([^.]+)$");
        this.mimetypes = new Properties();
        this.initMimetypes();
    }

    public String getMimeType(String filename) {
        return this.getMimeType(filename, "");
    }

    public String getMimeType(String filename, String defaultMimeType) {
        Matcher matcher = this.extPattern.matcher(filename.toLowerCase());
        String ext = "";
        if (matcher.matches()) {
            ext = matcher.group(1);
        }
        if (ext.length() > 0) {
            String mimeType = this.mimetypes.getProperty(ext);
            if (mimeType == null) {
                return defaultMimeType;
            }
            return mimeType;
        }
        return defaultMimeType;
    }

    public String getContentType(Context context, String filename) {
        return this.getContentType(context, filename, "application/octet-stream");
    }

    public String getContentType(Context context, String filename, String defaultContentType) {
        String contentType = this.getMimeType(filename, null);
        if (contentType == null) {
            contentType = defaultContentType;
        }
        if (contentType != null && contentType.startsWith("text/")) {
            return contentType + "; charset=utf-8";
        }
        return contentType;
    }

    public boolean isValidMimeType(String mimeType) {
        if (mimeType == null) {
            return false;
        }
        if (mimeType.indexOf(";") != -1) {
            return this.mimetypes.contains(mimeType.split(";")[0]);
        }
        return this.mimetypes.contains(mimeType);
    }

    private void initMimetypes() {
        try (InputStream is = this.getClass().getClassLoader().getResourceAsStream("ninja/utils/mime-types.properties");){
            this.mimetypes.load(is);
        }
        catch (Exception e) {
            this.logger.error("Failed to load mimetypes", (Throwable)e);
        }
        Enumeration<?> confenum = this.ninjaProperties.getAllCurrentNinjaProperties().propertyNames();
        while (confenum.hasMoreElements()) {
            String key = (String)confenum.nextElement();
            if (!key.startsWith("mimetype.")) continue;
            String type = key.substring(key.indexOf(46) + 1).toLowerCase();
            String value = this.ninjaProperties.get(key);
            this.mimetypes.setProperty(type, value);
        }
    }
}

