/*
 * Decompiled with CFR 0.152.
 */
package ninja.utils;

import com.google.common.base.Optional;
import ninja.utils.NinjaMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NinjaModeHelper {
    static Logger logger = LoggerFactory.getLogger(NinjaModeHelper.class);

    public static Optional<NinjaMode> determineModeFromSystemProperties() {
        NinjaMode ninjaMode = null;
        String modeFromGetSystemProperty = System.getProperty("ninja.mode");
        if (modeFromGetSystemProperty != null) {
            if (modeFromGetSystemProperty.equals("test")) {
                ninjaMode = NinjaMode.test;
            } else if (modeFromGetSystemProperty.equals("dev")) {
                ninjaMode = NinjaMode.dev;
            } else if (modeFromGetSystemProperty.equals("prod")) {
                ninjaMode = NinjaMode.prod;
            }
        }
        return Optional.fromNullable(ninjaMode);
    }

    public static NinjaMode determineModeFromSystemPropertiesOrProdIfNotSet() {
        Optional<NinjaMode> ninjaModeOptional = NinjaModeHelper.determineModeFromSystemProperties();
        NinjaMode ninjaMode = !ninjaModeOptional.isPresent() ? NinjaMode.prod : (NinjaMode)((Object)ninjaModeOptional.get());
        logger.info("Ninja is running in mode {}", (Object)ninjaMode.toString());
        return ninjaMode;
    }
}

