/*
 * Decompiled with CFR 0.152.
 */
package ninja.utils;

import com.google.inject.Inject;
import javax.inject.Singleton;
import ninja.AsyncResult;
import ninja.Context;
import ninja.Renderable;
import ninja.Result;
import ninja.exceptions.BadRequestException;
import ninja.exceptions.NinjaException;
import ninja.template.TemplateEngine;
import ninja.template.TemplateEngineManager;
import ninja.utils.NoHttpBody;
import org.slf4j.Logger;

@Singleton
public class ResultHandler {
    private final TemplateEngineManager templateEngineManager;
    private final Logger logger;

    @Inject
    public ResultHandler(Logger logger, TemplateEngineManager templateEngineManager) {
        this.logger = logger;
        this.templateEngineManager = templateEngineManager;
    }

    public void handleResult(Result result, Context context) {
        if (result == null || result instanceof AsyncResult) {
            return;
        }
        Object objectToBeRendered = result.getRenderable();
        if (objectToBeRendered instanceof Renderable) {
            this.handleRenderable((Renderable)objectToBeRendered, context, result);
        } else {
            if (!result.getHeaders().containsKey("Cache-Control")) {
                result.doNotCacheContent();
            }
            if (objectToBeRendered instanceof NoHttpBody) {
                context.finalizeHeaders(result);
            } else {
                this.renderWithTemplateEngineOrRaw(context, result);
            }
        }
    }

    private void handleRenderable(Renderable renderable, Context context, Result result) {
        renderable.render(context, result);
    }

    private void renderWithTemplateEngineOrRaw(Context context, Result result) {
        TemplateEngine templateEngine;
        if (result.getContentType() == null) {
            if (result.supportedContentTypes().contains(context.getAcceptContentType())) {
                result.contentType(context.getAcceptContentType());
            } else if (result.fallbackContentType().isPresent()) {
                result.contentType((String)result.fallbackContentType().get());
            } else {
                throw new BadRequestException("No idea how to handle incoming request with Accept:" + context.getAcceptContentType() + " at route " + context.getRequestPath());
            }
        }
        if ((templateEngine = this.templateEngineManager.getTemplateEngineForContentType(result.getContentType())) == null) {
            throw new NinjaException(404, "No template engine found for result content type " + result.getContentType());
        }
        templateEngine.invoke(context, result);
    }
}

