/*
 * Decompiled with CFR 0.152.
 */
package ninja.utils;

import com.google.common.base.CaseFormat;
import com.google.common.primitives.Primitives;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.joda.time.LocalDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwissKnife {
    private static final Logger logger;
    private static final Map<String, Method> CONVERTERS;

    public static PropertiesConfiguration loadConfigurationInUtf8(String fileOrUrlOrClasspathUrl) {
        PropertiesConfiguration propertiesConfiguration = new PropertiesConfiguration();
        propertiesConfiguration.setEncoding("utf-8");
        propertiesConfiguration.setDelimiterParsingDisabled(true);
        propertiesConfiguration.setFileName(fileOrUrlOrClasspathUrl);
        propertiesConfiguration.getLayout().setSingleLine("application.secret", true);
        try {
            propertiesConfiguration.load(fileOrUrlOrClasspathUrl);
        }
        catch (ConfigurationException e) {
            logger.info("Could not load file " + fileOrUrlOrClasspathUrl + " (not a bad thing necessarily, but I am returing null)");
            return null;
        }
        return propertiesConfiguration;
    }

    public static String getRealClassNameLowerCamelCase(Object object) {
        return CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, object.getClass().getSimpleName());
    }

    public static <T> Collection<T> convertCollection(String[] from, Class<T> to) {
        ArrayList<T> result = new ArrayList<T>();
        for (String value : from) {
            result.add(SwissKnife.convert(value, to));
        }
        return result;
    }

    public static <T> T[] convertArray(String[] from, Class<T> to) {
        Object[] result;
        try {
            result = (Object[])Array.newInstance(to, from.length);
        }
        catch (ClassCastException e) {
            return null;
        }
        for (int i = 0; i < from.length; ++i) {
            result[i] = SwissKnife.convert(from[i], to);
        }
        return result;
    }

    public static <T> T convert(String from, Class<T> to) {
        if (from == null) {
            return null;
        }
        T t = null;
        Class toAsNonPrimitiveType = Primitives.wrap(to);
        if (toAsNonPrimitiveType.isAssignableFrom(from.getClass())) {
            return toAsNonPrimitiveType.cast(from);
        }
        Method converter = CONVERTERS.get(toAsNonPrimitiveType.getName());
        if (converter == null) {
            logger.error("No converter found to convert {}. Returning null. You may want to extend the class.", (Object)toAsNonPrimitiveType);
        } else {
            try {
                t = toAsNonPrimitiveType.cast(converter.invoke((Object)toAsNonPrimitiveType, from));
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
                logger.error("Cannot convert from " + from.getClass().getName() + " to " + toAsNonPrimitiveType.getName() + ". Conversion failed with " + ex.getMessage(), (Throwable)ex);
            }
        }
        return t;
    }

    static {
        Method[] methods;
        logger = LoggerFactory.getLogger(SwissKnife.class);
        CONVERTERS = new HashMap<String, Method>();
        for (Method method : methods = Converter.class.getDeclaredMethods()) {
            if (method.getParameterTypes().length != 1 || method.getParameterTypes()[0] != String.class) continue;
            CONVERTERS.put(method.getReturnType().getName(), method);
        }
    }

    private static class Converter {
        private Converter() {
        }

        public static Integer toInteger(String value) {
            return Integer.valueOf(value);
        }

        public static Long toLong(String value) {
            return Long.valueOf(value);
        }

        public static Float toFloat(String value) {
            return Float.valueOf(value);
        }

        public static Double toDouble(String value) {
            return Double.valueOf(value);
        }

        public static Boolean toBoolean(String value) {
            return Boolean.valueOf(value);
        }

        public static Byte toByte(String value) {
            return Byte.valueOf(value);
        }

        public static Short toShort(String value) {
            return Short.valueOf(value);
        }

        public static Date toDate(String value) {
            if (value != null && value.length() > 0) {
                return new LocalDateTime((Object)value).toDate();
            }
            return null;
        }

        public static Character toCharacter(String value) {
            if (value.length() > 0) {
                return Character.valueOf(value.charAt(0));
            }
            return null;
        }
    }
}

