/*
 * Decompiled with CFR 0.152.
 */
package ninja.validation;

import java.util.ArrayList;
import java.util.List;
import ninja.validation.ConstraintViolation;
import ninja.validation.FieldViolation;
import ninja.validation.Validation;

public class ValidationImpl
implements Validation {
    private final List<FieldViolation> fieldViolations = new ArrayList<FieldViolation>();
    private final List<ConstraintViolation> generalViolations = new ArrayList<ConstraintViolation>();
    private final List<FieldViolation> beanViolations = new ArrayList<FieldViolation>();

    @Override
    public boolean hasViolations() {
        return !this.fieldViolations.isEmpty() || !this.generalViolations.isEmpty() || !this.beanViolations.isEmpty();
    }

    @Override
    public void addFieldViolation(FieldViolation fieldViolation) {
        if (fieldViolation.field == null) {
            this.generalViolations.add(fieldViolation.constraintViolation);
        } else {
            this.fieldViolations.add(fieldViolation);
        }
    }

    @Override
    public void addFieldViolation(String field, ConstraintViolation constraintViolation) {
        this.addFieldViolation(new FieldViolation(field, constraintViolation));
    }

    @Override
    public boolean hasFieldViolation(String field) {
        for (FieldViolation fieldViolation : this.fieldViolations) {
            if (!fieldViolation.field.contentEquals(field)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<FieldViolation> getFieldViolations() {
        return this.fieldViolations;
    }

    @Override
    public List<FieldViolation> getFieldViolations(String field) {
        ArrayList<FieldViolation> violationsForThisField = new ArrayList<FieldViolation>();
        for (FieldViolation fieldViolation : this.fieldViolations) {
            if (!fieldViolation.field.contentEquals(field)) continue;
            violationsForThisField.add(fieldViolation);
        }
        return violationsForThisField;
    }

    @Override
    public void addBeanViolation(FieldViolation fieldViolation) {
        this.beanViolations.add(fieldViolation);
    }

    @Override
    public boolean hasBeanViolation(String field) {
        for (FieldViolation beanViolation : this.beanViolations) {
            if (!beanViolation.field.contentEquals(field)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasBeanViolations() {
        return !this.beanViolations.isEmpty();
    }

    @Override
    public List<FieldViolation> getBeanViolations() {
        return this.beanViolations;
    }

    @Override
    public void addViolation(ConstraintViolation constraintViolation) {
        this.generalViolations.add(constraintViolation);
    }

    @Override
    public List<ConstraintViolation> getGeneralViolations() {
        return this.generalViolations;
    }
}

