/*
 * Decompiled with CFR 0.152.
 */
package ninja.standalone;

import com.google.inject.Injector;
import com.google.inject.servlet.GuiceFilter;
import java.net.URI;
import java.util.EventListener;
import ninja.servlet.NinjaServletListener;
import ninja.utils.NinjaMode;
import ninja.utils.NinjaModeHelper;
import ninja.utils.NinjaPropertiesImpl;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.ServletContextHandler;

public class NinjaJetty {
    public static final String COMMAND_LINE_PARAMETER_NINJA_CONTEXT = "ninja.context";
    public static final String COMMAND_LINE_PARAMETER_NINJA_PORT = "ninja.port";
    static final int DEFAULT_PORT = 8080;
    Integer port = 8080;
    URI serverUri = URI.create("http://localhost:" + this.port);
    NinjaMode ninjaMode = NinjaMode.dev;
    Server server;
    ServletContextHandler context;
    String ninjaContextPath;
    NinjaServletListener ninjaServletListener = new NinjaServletListener();

    public static void main(String[] args) {
        NinjaMode ninjaMode = NinjaModeHelper.determineModeFromSystemPropertiesOrProdIfNotSet();
        int port = NinjaJetty.tryToGetPortFromSystemPropertyOrReturnDefault();
        String contextPath = NinjaJetty.tryToGetContextPathFromSystemPropertyOrReturnDefault();
        final NinjaJetty ninjaJetty = new NinjaJetty();
        ninjaJetty.setNinjaMode(ninjaMode);
        ninjaJetty.setPort(port);
        ninjaJetty.setNinjaContextPath(contextPath);
        ninjaJetty.start();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                ninjaJetty.shutdown();
            }
        });
    }

    public Injector getInjector() {
        return this.ninjaServletListener.getInjector();
    }

    public NinjaJetty setPort(int port) {
        this.port = port;
        return this;
    }

    public NinjaJetty setServerUri(URI serverUri) {
        this.serverUri = serverUri;
        return this;
    }

    public NinjaJetty setNinjaMode(NinjaMode ninjaMode) {
        this.ninjaMode = ninjaMode;
        return this;
    }

    public NinjaJetty setNinjaContextPath(String ninjaContextPath) {
        this.ninjaContextPath = ninjaContextPath;
        return this;
    }

    public void start() {
        this.server = new Server(this.port.intValue());
        try {
            ServerConnector http = new ServerConnector(this.server);
            this.server.addConnector((Connector)http);
            this.context = new ServletContextHandler((HandlerContainer)this.server, this.ninjaContextPath);
            NinjaPropertiesImpl ninjaProperties = new NinjaPropertiesImpl(this.ninjaMode);
            ninjaProperties.setProperty("application.server.name", this.serverUri.toString());
            this.ninjaServletListener.setNinjaProperties(ninjaProperties);
            this.context.addEventListener((EventListener)this.ninjaServletListener);
            this.context.addFilter(GuiceFilter.class, "/*", null);
            this.context.addServlet(DefaultServlet.class, "/");
            this.server.start();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public void shutdown() {
        try {
            this.server.stop();
            this.server.destroy();
            this.context.stop();
            this.context.destroy();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String getServerAddress() {
        return this.serverUri.toString() + "/";
    }

    public URI getServerAddressAsUri() {
        return this.serverUri;
    }

    public static int tryToGetPortFromSystemPropertyOrReturnDefault() {
        Integer port;
        try {
            String portAsString = System.getProperty(COMMAND_LINE_PARAMETER_NINJA_PORT);
            port = Integer.parseInt(portAsString);
        }
        catch (Exception e) {
            return 8080;
        }
        return port;
    }

    public static String tryToGetContextPathFromSystemPropertyOrReturnDefault() {
        try {
            String contextPath = System.getProperty(COMMAND_LINE_PARAMETER_NINJA_CONTEXT);
            return contextPath;
        }
        catch (Exception e) {
            return null;
        }
    }
}

