/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.extend.consul;

import java.util.Timer;
import java.util.TimerTask;
import org.noear.solon.Utils;
import org.noear.solon.cloud.CloudClient;
import org.noear.solon.cloud.CloudManager;
import org.noear.solon.cloud.extend.consul.ConsulProps;
import org.noear.solon.cloud.extend.consul.service.CloudConfigServiceConsulImpl;
import org.noear.solon.cloud.extend.consul.service.CloudDiscoveryServiceConsulImpl;
import org.noear.solon.cloud.service.CloudConfigService;
import org.noear.solon.cloud.service.CloudDiscoveryService;
import org.noear.solon.core.AopContext;
import org.noear.solon.core.Plugin;

public class XPluginImp
implements Plugin {
    private Timer clientTimer = new Timer();

    public void start(AopContext context) {
        long interval;
        TimerTask serviceImp;
        if (Utils.isEmpty((String)ConsulProps.instance.getServer())) {
            return;
        }
        if (ConsulProps.instance.getConfigEnable()) {
            serviceImp = new CloudConfigServiceConsulImpl(ConsulProps.instance);
            CloudManager.register((CloudConfigService)serviceImp);
            if (((CloudConfigServiceConsulImpl)serviceImp).getRefreshInterval() > 0L) {
                interval = ((CloudConfigServiceConsulImpl)serviceImp).getRefreshInterval();
                this.clientTimer.schedule(serviceImp, interval, interval);
            }
            CloudClient.configLoad((String)ConsulProps.instance.getConfigLoad());
            CloudClient.configLoad((String)ConsulProps.instance.getConfigLoadGroup(), (String)ConsulProps.instance.getConfigLoadKey());
        }
        if (ConsulProps.instance.getDiscoveryEnable()) {
            serviceImp = new CloudDiscoveryServiceConsulImpl(ConsulProps.instance);
            CloudManager.register((CloudDiscoveryService)serviceImp);
            ((CloudDiscoveryServiceConsulImpl)serviceImp).run();
            if (((CloudDiscoveryServiceConsulImpl)serviceImp).getRefreshInterval() > 0L) {
                interval = ((CloudDiscoveryServiceConsulImpl)serviceImp).getRefreshInterval();
                this.clientTimer.schedule(serviceImp, interval, interval);
            }
        }
    }

    public void prestop() throws Throwable {
        if (this.clientTimer != null) {
            this.clientTimer.cancel();
        }
    }
}

