/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.extend.consul;

import com.ecwid.consul.v1.ConsulClient;
import java.util.Timer;
import java.util.TimerTask;
import org.noear.solon.SolonApp;
import org.noear.solon.Utils;
import org.noear.solon.core.Bridge;
import org.noear.solon.core.LoadBalance;
import org.noear.solon.core.Plugin;
import org.noear.solon.extend.consul.ConsulConfigTask;
import org.noear.solon.extend.consul.ConsulLocatorTask;
import org.noear.solon.extend.consul.ConsulRegisterTask;
import org.noear.solon.extend.consul.LoadBalanceSimpleFactory;
import org.noear.solon.extend.consul.Tools;

public class XPluginImp
implements Plugin {
    private Timer clientTimer = new Timer();
    private ConsulClient client;
    private String serviceId;

    public void start(SolonApp app) {
        long interval;
        String host = app.cfg().get("consul.host");
        if (Utils.isEmpty((String)host)) {
            return;
        }
        int consulPort = app.cfg().getInt("consul.port", 8500);
        this.client = new ConsulClient(host, consulPort);
        this.serviceId = app.cfg().appName() + "-" + app.port();
        if (app.cfg().getBool("consul.discovery.enable", true)) {
            new ConsulRegisterTask(this.client).run();
        }
        if (app.cfg().getBool("consul.config.enable", true)) {
            ConsulConfigTask configTask = new ConsulConfigTask(this.client);
            configTask.run();
            interval = Tools.getInterval(app.cfg().get("consul.config.interval", "10s"));
            if (interval > 0L) {
                this.clientTimer.schedule((TimerTask)configTask, interval, interval);
            }
        }
        if (app.cfg().getBool("consul.locator.enable", true)) {
            LoadBalanceSimpleFactory factory = new LoadBalanceSimpleFactory();
            Bridge.upstreamFactorySet((LoadBalance.Factory)factory);
            interval = Tools.getInterval(app.cfg().get("consul.locator.interval", "10s"));
            ConsulLocatorTask locatorTask = new ConsulLocatorTask(this.client, factory);
            locatorTask.run();
            if (interval > 0L) {
                this.clientTimer.schedule((TimerTask)locatorTask, interval, interval);
            }
        }
    }

    public void stop() throws Throwable {
        if (this.client != null) {
            this.client.agentServiceDeregister(this.serviceId);
        }
        this.clientTimer.cancel();
    }
}

