/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.extend.consul.detector;

import com.wujiuye.flow.FlowHelper;
import com.wujiuye.flow.FlowType;
import com.wujiuye.flow.Flower;
import java.util.HashMap;
import java.util.Map;
import org.noear.solon.SolonApp;
import org.noear.solon.extend.consul.detector.AbstractDetector;

public class QpsDetector
extends AbstractDetector {
    protected final FlowHelper flowHelper;

    public QpsDetector(FlowType ... types) {
        this.flowHelper = new FlowHelper(types);
    }

    public QpsDetector() {
        this(FlowType.Second);
    }

    @Override
    public String getName() {
        return "qps";
    }

    @Override
    public Map<String, Object> getInfo() {
        HashMap<String, Object> info = new HashMap<String, Object>();
        Flower flower = this.flowHelper.getFlow(FlowType.Second);
        info.put("total", flower.total());
        info.put("totalException", flower.totalException());
        info.put("totalSuccess", flower.totalSuccess());
        info.put("argRt", flower.avgRt());
        info.put("maxRt", flower.maxRt());
        info.put("minRt", flower.minRt());
        info.put("successAvg", flower.successAvg());
        info.put("exceptionAvg", flower.exceptionAvg());
        return info;
    }

    public void toDetect(SolonApp solon) {
        solon.before("/**", ctx -> ctx.attrSet("_begin_time", (Object)System.currentTimeMillis()));
        solon.after("/**", ctx -> {
            Long begin = (Long)ctx.attr("_begin_time");
            if (begin != null) {
                this.flowHelper.incrSuccess(System.currentTimeMillis() - begin);
            }
        });
        solon.onError(e -> this.flowHelper.incrException());
    }
}

