/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.extend.consul.detector;

import java.util.HashMap;
import java.util.Map;
import org.noear.solon.cloud.extend.consul.detector.AbstractDetector;

public class JvmMemoryDetector
extends AbstractDetector {
    @Override
    public String getName() {
        return "jvm";
    }

    @Override
    public Map<String, Object> getInfo() {
        HashMap<String, Object> info = new HashMap<String, Object>();
        Runtime run = Runtime.getRuntime();
        long max = run.maxMemory();
        long total = run.totalMemory();
        long free = run.freeMemory();
        long used = total - free;
        long usable = max - used;
        if (max > 0L) {
            float ratio = (float)used * 100.0f / (float)max;
            info.put("ratio", Float.valueOf(ratio));
        }
        info.put("total", JvmMemoryDetector.formatByteSize(total));
        info.put("used", JvmMemoryDetector.formatByteSize(used));
        info.put("free", JvmMemoryDetector.formatByteSize(free));
        return info;
    }
}

