/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.extend.consul.service;

import com.ecwid.consul.v1.ConsulClient;
import com.ecwid.consul.v1.Response;
import com.ecwid.consul.v1.agent.model.NewService;
import com.ecwid.consul.v1.agent.model.Service;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimerTask;
import org.noear.solon.Utils;
import org.noear.solon.cloud.CloudDiscoveryHandler;
import org.noear.solon.cloud.CloudProps;
import org.noear.solon.cloud.model.Discovery;
import org.noear.solon.cloud.model.Instance;
import org.noear.solon.cloud.service.CloudDiscoveryObserverEntity;
import org.noear.solon.cloud.service.CloudDiscoveryService;
import org.noear.solon.cloud.utils.IntervalUtils;
import org.noear.solon.core.event.EventBus;

public class CloudDiscoveryServiceConsulImpl
extends TimerTask
implements CloudDiscoveryService {
    private ConsulClient real;
    private String token;
    private long refreshInterval;
    private String healthCheckInterval;
    private List<String> tags;
    Map<String, Discovery> discoveryMap = new HashMap<String, Discovery>();
    private Map<CloudDiscoveryHandler, CloudDiscoveryObserverEntity> observerMap = new HashMap<CloudDiscoveryHandler, CloudDiscoveryObserverEntity>();

    public CloudDiscoveryServiceConsulImpl(CloudProps cloudProps) {
        String server;
        String[] ss;
        this.token = cloudProps.getToken();
        this.refreshInterval = IntervalUtils.getInterval((String)cloudProps.getDiscoveryRefreshInterval("5s"));
        this.healthCheckInterval = cloudProps.getDiscoveryHealthCheckInterval("5s");
        String tags_str = cloudProps.getDiscoveryTags();
        if (Utils.isNotEmpty((String)tags_str)) {
            this.tags = Arrays.asList(tags_str.split(","));
        }
        this.real = (ss = (server = cloudProps.getDiscoveryServer()).split(":")).length == 1 ? new ConsulClient(ss[0]) : new ConsulClient(ss[0], Integer.parseInt(ss[1]));
    }

    public long getRefreshInterval() {
        return this.refreshInterval;
    }

    public void register(String group, Instance instance) {
        String[] ss = instance.address().split(":");
        String serviceId = instance.service() + "-" + instance.address();
        NewService newService = new NewService();
        newService.setId(serviceId);
        newService.setName(instance.service());
        newService.setAddress(ss[0]);
        newService.setPort(Integer.valueOf(Integer.parseInt(ss[1])));
        newService.setMeta(instance.meta());
        if (instance.tags() != null) {
            newService.setTags(instance.tags());
        }
        if (this.tags != null) {
            if (newService.getTags() != null) {
                newService.getTags().addAll(this.tags);
            } else {
                newService.setTags(this.tags);
            }
        }
        this.registerLocalCheck(instance, newService);
        this.real.agentServiceRegister(newService, this.token);
    }

    public void registerState(String group, Instance instance, boolean health) {
        String serviceId = instance.service() + "-" + instance.address();
        this.real.agentServiceSetMaintenance(serviceId, health);
    }

    private void registerLocalCheck(Instance instance, NewService newService) {
        if (Utils.isNotEmpty((String)this.healthCheckInterval)) {
            String protocol = Utils.annoAlias((String)instance.protocol(), (String)"http");
            if (protocol.startsWith("http")) {
                String checkUrl = protocol + "://" + instance.address();
                checkUrl = "/healthz".startsWith("/") ? checkUrl + "/healthz" : checkUrl + "/" + "/healthz";
                NewService.Check check = new NewService.Check();
                check.setInterval(this.healthCheckInterval);
                check.setMethod("GET");
                check.setHttp(checkUrl);
                check.setDeregisterCriticalServiceAfter("30s");
                check.setTimeout("6s");
                newService.setCheck(check);
            }
            if (protocol.startsWith("tcp") || protocol.startsWith("ws")) {
                NewService.Check check = new NewService.Check();
                check.setInterval(this.healthCheckInterval);
                check.setTcp(instance.address());
                check.setTimeout("6s");
                newService.setCheck(check);
            }
        }
    }

    public void deregister(String group, Instance instance) {
        String serviceId = instance.service() + "-" + instance.address();
        this.real.agentServiceDeregister(serviceId);
    }

    public Discovery find(String group, String service) {
        return this.discoveryMap.get(service);
    }

    public void attention(String group, String service, CloudDiscoveryHandler observer) {
        this.observerMap.put(observer, new CloudDiscoveryObserverEntity(group, service, observer));
    }

    @Override
    public void run() {
        try {
            this.run0();
        }
        catch (Throwable ex) {
            EventBus.push((Object)ex);
        }
    }

    private void run0() {
        HashMap<String, Discovery> discoveryTmp = new HashMap<String, Discovery>();
        Response services = this.real.getAgentServices();
        for (Map.Entry kv : ((Map)services.getValue()).entrySet()) {
            Service service = (Service)kv.getValue();
            if (Utils.isEmpty((String)service.getAddress())) continue;
            String name = service.getService();
            Discovery discovery = (Discovery)discoveryTmp.get(name);
            if (discovery == null) {
                discovery = new Discovery(service.getService());
                discoveryTmp.put(name, discovery);
            }
            Instance n1 = new Instance(service.getService(), service.getAddress() + ":" + service.getPort()).tagsAddAll((Collection)service.getTags()).metaPutAll(service.getMeta());
            discovery.instanceAdd(n1);
        }
        this.discoveryMap = discoveryTmp;
        this.noticeObservers();
    }

    private void noticeObservers() {
        for (Map.Entry<CloudDiscoveryHandler, CloudDiscoveryObserverEntity> kv : this.observerMap.entrySet()) {
            CloudDiscoveryObserverEntity entity = kv.getValue();
            Discovery tmp = this.discoveryMap.get(entity.service);
            if (tmp == null) continue;
            entity.handle(tmp);
        }
    }
}

