/*
 * Decompiled with CFR 0.152.
 */
package com.drools.solon.util;

import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicInteger;

public class ScheduledThreadPoolExecutorUtil {
    public static ScheduledThreadPoolExecutor RULE_SCHEDULE = new ScheduledThreadPoolExecutor(Runtime.getRuntime().availableProcessors() * 2, new DefaultThreadFactory("rule-schedule-"), new ThreadPoolExecutor.AbortPolicy(){

        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor e) {
            throw new RejectedExecutionException("\u81ea\u52a8\u88c5\u8f7d\u89c4\u5219\u6587\u4ef6\u5f02\u5e38\uff1a" + e);
        }
    });
    public static ScheduledThreadPoolExecutor CACHE_KIE = new ScheduledThreadPoolExecutor(Runtime.getRuntime().availableProcessors() * 2, new DefaultThreadFactory("cache-kie-schedule-"), new ThreadPoolExecutor.AbortPolicy(){

        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor e) {
            throw new RejectedExecutionException("\u6301\u4e45\u5316Kie\u5f02\u5e38\uff1a" + e);
        }
    });

    private ScheduledThreadPoolExecutorUtil() {
    }

    static class DefaultThreadFactory
    implements ThreadFactory {
        private static final AtomicInteger POOL_NUMBER = new AtomicInteger(1);
        private final ThreadGroup group;
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        private final String namePrefix;

        DefaultThreadFactory(String name) {
            SecurityManager s = System.getSecurityManager();
            this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.namePrefix = name + "-pool-" + POOL_NUMBER.getAndIncrement() + "-thread-";
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
            if (t.isDaemon()) {
                t.setDaemon(false);
            }
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }
}

