/*
 * Decompiled with CFR 0.152.
 */
package com.drools.solon;

import com.drools.solon.KieAccessor;
import com.drools.solon.listener.DefaultAgendaEventListener;
import com.drools.solon.listener.DefaultProcessEventListener;
import com.drools.solon.listener.DefaultRuleRuntimeEventListener;
import com.drools.solon.util.FileUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import org.drools.decisiontable.InputType;
import org.drools.decisiontable.SpreadsheetCompiler;
import org.kie.api.KieBase;
import org.kie.api.KieBaseConfiguration;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.Message;
import org.kie.api.builder.Results;
import org.kie.api.conf.EventProcessingOption;
import org.kie.api.conf.KieBaseOption;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.event.rule.AgendaEventListener;
import org.kie.api.event.rule.RuleRuntimeEventListener;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSession;
import org.kie.internal.io.ResourceFactory;
import org.kie.internal.utils.KieHelper;
import org.noear.solon.Utils;

public class KieTemplate
extends KieAccessor {
    private Map<String, String> CACHE_RULE = new ConcurrentHashMap<String, String>();
    private static Map<String, BlockingQueue<KieSession>> SESSION = new ConcurrentHashMap<String, BlockingQueue<KieSession>>();
    private static Map<String, BlockingQueue<KieBase>> BASE = new ConcurrentHashMap<String, BlockingQueue<KieBase>>();

    public KieTemplate() {
        this.setCharset("UTF-8");
    }

    public KieSession getKieSession(String ... fileName) {
        List<Object> ds = new ArrayList<String>();
        for (String name : fileName) {
            String content = this.CACHE_RULE.get(name);
            if (Utils.isBlank((String)content)) {
                ds = this.doReadTemp(fileName);
                return this.decodeToSession(ds.toArray(new String[0]));
            }
            ds.add(this.CACHE_RULE.get(name));
        }
        return this.decodeToSession(ds.toArray(new String[0]));
    }

    public String encodeToString(String realPath) {
        File file = new File(realPath);
        if (!file.exists()) {
            return null;
        }
        if (realPath.endsWith("drl")) {
            return this.read(file);
        }
        FileInputStream is = null;
        try {
            is = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            this.logger.error("file not fount.");
        }
        if (realPath.endsWith("xls") || realPath.endsWith("xlsx")) {
            return new SpreadsheetCompiler().compile((InputStream)is, InputType.XLS);
        }
        if (realPath.endsWith("csv")) {
            return new SpreadsheetCompiler().compile((InputStream)is, InputType.CSV);
        }
        if (is != null) {
            try {
                ((InputStream)is).close();
            }
            catch (IOException e) {
                this.logger.error("close stream error=>", (Throwable)e);
            }
        }
        return "package src.main.resources;";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String read(File file) {
        FileInputStream fis = null;
        InputStreamReader isr = null;
        BufferedReader br = null;
        try {
            String line;
            fis = new FileInputStream(file);
            isr = new InputStreamReader((InputStream)fis, this.getCharset());
            br = new BufferedReader(isr);
            StringBuilder builder = new StringBuilder();
            boolean tf = true;
            while ((line = br.readLine()) != null) {
                if (tf) {
                    builder.append(line);
                    tf = false;
                    continue;
                }
                builder.append("\n").append(line);
            }
            String string = builder.toString();
            return string;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
                if (isr != null) {
                    isr.close();
                }
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public KieSession decodeToSession(String ... drl) {
        Results results;
        KieHelper kieHelper = new KieHelper();
        for (String s : drl) {
            kieHelper.addContent(s, ResourceType.DRL);
        }
        if (this.getVerify() != null && "on".equalsIgnoreCase(this.getVerify()) && (results = kieHelper.verify()).hasMessages(new Message.Level[]{Message.Level.WARNING, Message.Level.ERROR})) {
            List messages = results.getMessages(new Message.Level[]{Message.Level.WARNING, Message.Level.ERROR});
            for (Message message : messages) {
                this.logger.error("Error: {}", (Object)message.getText());
            }
            throw new IllegalStateException("Compilation errors.");
        }
        KieBaseConfiguration config = kieHelper.ks.newKieBaseConfiguration();
        if (EventProcessingOption.STREAM.getMode().equalsIgnoreCase(this.getMode())) {
            config.setOption((KieBaseOption)EventProcessingOption.STREAM);
        } else {
            config.setOption((KieBaseOption)EventProcessingOption.CLOUD);
        }
        KieBase kieBase = kieHelper.build(config);
        KieSession kieSession = kieBase.newKieSession();
        if (this.getListener() == null || !"off".equalsIgnoreCase(this.getListener())) {
            kieSession.addEventListener((RuleRuntimeEventListener)new DefaultRuleRuntimeEventListener());
            kieSession.addEventListener((AgendaEventListener)new DefaultAgendaEventListener());
            kieSession.addEventListener((ProcessEventListener)new DefaultProcessEventListener());
        }
        return kieSession;
    }

    public KieBase getKieBase(String classPath) throws Exception {
        KieServices kieServices = KieServices.Factory.get();
        KieFileSystem kfs = kieServices.newKieFileSystem();
        Resource resource = ResourceFactory.newFileResource((String)classPath);
        kfs.write(resource);
        KieBuilder kieBuilder = kieServices.newKieBuilder(kfs).buildAll();
        if (kieBuilder.getResults().getMessages(new Message.Level[]{Message.Level.ERROR}).size() > 0) {
            throw new Exception();
        }
        KieContainer kieContainer = kieServices.newKieContainer(kieServices.getRepository().getDefaultReleaseId());
        return kieContainer.getKieBase();
    }

    public void doRead0() {
        String pathTotal = this.getPath();
        if (pathTotal == null || pathTotal.length() == 0) {
            return;
        }
        String[] pathArray = pathTotal.split(",");
        ArrayList<File> fileList = new ArrayList<File>();
        for (String path : pathArray) {
            FileUtil.fileList(path, fileList);
        }
        for (File file : fileList) {
            String fileName = file.getName();
            String content = this.encodeToString(file.getPath());
            this.CACHE_RULE.put(fileName, content);
        }
    }

    private List<String> doReadTemp(String ... fileName) {
        String pathTotal = this.getPath();
        if (Utils.isBlank((String)pathTotal)) {
            throw new IllegalArgumentException("path must be not null");
        }
        List<String> fl = Arrays.asList(fileName);
        ArrayList<String> ds = new ArrayList<String>();
        String[] pathArray = pathTotal.split(",");
        ArrayList<File> fileList = new ArrayList<File>();
        for (String path : pathArray) {
            FileUtil.fileList(path, fileList);
        }
        for (File file : fileList) {
            if (!fl.contains(file.getName())) continue;
            String content = this.encodeToString(file.getPath());
            ds.add(content);
            this.CACHE_RULE.put(file.getName(), content);
        }
        return ds;
    }
}

