/*
 * Decompiled with CFR 0.152.
 */
package com.drools.solon.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Paths;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import org.noear.solon.core.util.ResourceUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtil {
    private static final Logger LOG;
    private static final String TEMP_DIR;

    public static void fileList(String path, List<File> fileList) {
        if (path.startsWith("classpath:")) {
            try {
                FileUtil.createTempDir();
                Enumeration resources = ResourceUtil.getResources((String)ResourceUtil.remSchema((String)path));
                while (resources.hasMoreElements()) {
                    URL resource = (URL)resources.nextElement();
                    fileList.add(FileUtil.copyResourceToTempFile(resource));
                }
            }
            catch (IOException e) {
                LOG.error("\u8d44\u6e90\u8bfb\u53d6\u5f02\u5e38\uff01", (Throwable)e);
            }
        } else {
            File file = new File(path);
            try {
                if (!file.exists()) {
                    return;
                }
                if (!file.getAbsolutePath().equals(file.getCanonicalPath())) {
                    LOG.info("\u8d44\u6e90\u6587\u4ef6,path:{},absolutePath{},[\u53ef\u80fd\u5b58\u5728\u6587\u4ef6\u88ab\u904d\u5386\u7684\u98ce\u9669]\uff01", (Object)path, (Object)file.getAbsolutePath());
                    return;
                }
                if (!file.isDirectory()) {
                    fileList.add(file);
                } else {
                    File[] f = file.listFiles();
                    if (f != null) {
                        for (File nextFile : f) {
                            FileUtil.fileList(nextFile.getPath(), fileList);
                        }
                    }
                }
            }
            catch (IOException e) {
                LOG.error("\u8d44\u6e90\u8bfb\u53d6\u5f02\u5e38[\u53ef\u80fd\u5b58\u5728\u6587\u4ef6\u88ab\u904d\u5386\u7684\u98ce\u9669]\uff01", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File copyResourceToTempFile(URL resource) {
        OutputStream os = null;
        File targetFile = null;
        int EOF = -1;
        try (InputStream is = resource.openStream();){
            int location;
            int count;
            int length = is.available();
            byte[] buffer = new byte[length];
            for (int remaining = length; remaining > 0 && EOF != (count = is.read(buffer, location = length - remaining, remaining)); remaining -= count) {
            }
            targetFile = new File(TEMP_DIR + File.separator + Paths.get(resource.toURI()).getFileName());
            os = new FileOutputStream(targetFile);
            os.write(buffer);
        }
        catch (Exception e) {
            LOG.error("\u8d44\u6e90\u6574\u5408\u5931\u8d25", (Throwable)e);
        }
        finally {
            try {
                if (os != null) {
                    os.close();
                }
            }
            catch (Exception e) {
                LOG.error("\u65e0\u6cd5\u5173\u95ed\u6587\u4ef6", (Throwable)e);
            }
        }
        return targetFile;
    }

    private static void createTempDir() {
        File file = new File(TEMP_DIR);
        if (!file.exists()) {
            file.mkdir();
        }
    }

    static {
        Map<String, String> map;
        String win;
        LOG = LoggerFactory.getLogger(FileUtil.class);
        boolean isLinux = System.getProperty("os.name").toLowerCase().contains("linux");
        TEMP_DIR = isLinux ? "/tmp" : ((win = (map = System.getenv()).get("TEMP")) != null && win.length() > 0 ? map.get("TEMP") : "temp");
    }
}

