/*
 * Decompiled with CFR 0.152.
 */
package org.noear.fairy;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import org.noear.fairy.FairyConfig;
import org.noear.fairy.FairyException;
import org.noear.fairy.FairyHandler;
import org.noear.fairy.IChannel;
import org.noear.fairy.IDecoder;
import org.noear.fairy.IEncoder;
import org.noear.fairy.IFilter;
import org.noear.fairy.Result;
import org.noear.fairy.Upstream;
import org.noear.fairy.annotation.FairyClient;

public class Fairy {
    public static IChannel defaultChannel;
    public static IEncoder defaultEncoder;
    public static IDecoder defaultDecoder;
    private String _url;
    private String _method = "POST";
    private final FairyConfig _config;
    private Result _result;

    public Fairy() {
        this._config = new FairyConfig().tryInit();
    }

    protected Fairy(FairyConfig config) {
        this._config = config;
        config.tryInit();
    }

    public Fairy method(String method) {
        if (method != null && method.length() > 0) {
            this._method = method;
        }
        return this;
    }

    public Fairy url(String url) {
        this._url = url;
        return this;
    }

    public Fairy url(String url, String fun) {
        if (url.indexOf("{fun}") > 0) {
            this._url = url.replace("{fun}", fun);
        } else if (fun == null) {
            this._url = url;
        } else {
            StringBuilder sb = new StringBuilder(200);
            sb.append(url);
            if (url.endsWith("/")) {
                if (fun.startsWith("/")) {
                    sb.append(fun.substring(1));
                } else {
                    sb.append(fun);
                }
            } else if (fun.startsWith("/")) {
                sb.append(fun);
            } else {
                sb.append("/").append(fun);
            }
            this._url = sb.toString();
        }
        return this;
    }

    public Fairy call(Map<String, String> headers, Map args) {
        try {
            if (headers == null) {
                headers = new HashMap<String, String>();
            }
            if (args == null) {
                args = new HashMap<String, Object>();
            }
            for (IFilter filter : this._config.getFilters()) {
                filter.filter(this._config, this._method, this._url, headers, args);
            }
            this._result = this._config.getChannel().call(this._config, this._method, this._url, headers, args);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
        return this;
    }

    public Result result() {
        return this._result;
    }

    public String getString() {
        return this._result.bodyAsString();
    }

    public <T> T getObject(Class<T> returnType) {
        if (Void.TYPE.equals(returnType)) {
            return null;
        }
        return this._config.getDecoder().decode(this._result, returnType);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final FairyConfig _config;

        protected Builder() {
            this._config = new FairyConfig();
        }

        protected Builder(FairyConfig config) {
            this._config = config;
        }

        public Builder upstream(Upstream upstream) {
            this._config.setUpstream(upstream);
            return this;
        }

        public Builder encoder(IEncoder encoder) {
            this._config.setEncoder(encoder);
            return this;
        }

        public Builder decoder(IDecoder decoder) {
            this._config.setDecoder(decoder);
            return this;
        }

        public Builder channel(IChannel channel) {
            this._config.setChannel(channel);
            return this;
        }

        public Builder filterAdd(IFilter filter) {
            this._config.filterAdd(filter);
            return this;
        }

        public Builder uri(String uri) {
            this._config.setUri(uri);
            return this;
        }

        public Fairy build() {
            return new Fairy(this._config);
        }

        public <T> T create(Class<?> clz) {
            FairyClient client = clz.getAnnotation(FairyClient.class);
            return (T)this.create(clz, client);
        }

        public Object create(Class<?> clz, FairyClient client) {
            if (clz == null) {
                return null;
            }
            if (!clz.isInterface()) {
                throw new FairyException("FairyClient only support interfaces");
            }
            FairyHandler handler = new FairyHandler(clz, this._config, client);
            return Proxy.newProxyInstance(clz.getClassLoader(), new Class[]{clz}, (InvocationHandler)handler);
        }
    }
}

