/*
 * Decompiled with CFR 0.152.
 */
package org.noear.fairy;

import java.util.LinkedHashSet;
import java.util.Set;
import org.noear.fairy.Fairy;
import org.noear.fairy.IChannel;
import org.noear.fairy.IDecoder;
import org.noear.fairy.IEncoder;
import org.noear.fairy.IFilter;
import org.noear.fairy.Upstream;
import org.noear.fairy.channel.OkHttpChannel;
import org.noear.fairy.decoder.FastjsonDecoder;
import org.noear.fairy.decoder.SnackDecoder;
import org.noear.fairy.encoder.FormEncoder;

public class FairyConfig {
    private static boolean HAS_SNACK3 = FairyConfig.hasClass("org.noear.snack.ONode");
    private static boolean HAS_FASTJSON = FairyConfig.hasClass("com.alibaba.fastjson.JSONObject");
    private IEncoder encoder;
    private IDecoder decoder;
    private IChannel channel;
    private Upstream upstream;
    private String uri;
    private Set<IFilter> filters = new LinkedHashSet<IFilter>();

    public FairyConfig() {
        this.encoder = Fairy.defaultEncoder;
        this.decoder = Fairy.defaultDecoder;
        this.channel = Fairy.defaultChannel;
    }

    public FairyConfig tryInit() {
        if (this.encoder == null) {
            this.setEncoder(FormEncoder.instance);
        }
        if (this.decoder == null) {
            if (HAS_FASTJSON) {
                this.setDecoder(FastjsonDecoder.instance);
            } else if (HAS_SNACK3) {
                this.setDecoder(SnackDecoder.instance);
            }
        }
        if (this.channel == null) {
            this.setChannel(OkHttpChannel.instance);
        }
        return this;
    }

    public IEncoder getEncoder() {
        return this.encoder;
    }

    protected void setEncoder(IEncoder encoder) {
        if (encoder != null) {
            this.encoder = encoder;
        }
    }

    public IDecoder getDecoder() {
        return this.decoder;
    }

    protected void setDecoder(IDecoder decoder) {
        if (decoder != null) {
            this.decoder = decoder;
        }
    }

    public IChannel getChannel() {
        return this.channel;
    }

    protected void setChannel(IChannel channel) {
        if (channel != null) {
            this.channel = channel;
        }
    }

    public Upstream getUpstream() {
        return this.upstream;
    }

    protected void setUpstream(Upstream upstream) {
        this.upstream = upstream;
    }

    public String getUri() {
        return this.uri;
    }

    protected void setUri(String uri) {
        this.uri = uri;
    }

    public Set<IFilter> getFilters() {
        return this.filters;
    }

    protected void filterAdd(IFilter filter) {
        this.filters.add(filter);
    }

    private static boolean hasClass(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (Throwable ex) {
            return false;
        }
    }
}

