/*
 * Decompiled with CFR 0.152.
 */
package org.noear.fairy;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.noear.fairy.Fairy;
import org.noear.fairy.FairyConfig;
import org.noear.fairy.FairyConfiguration;
import org.noear.fairy.FairyException;
import org.noear.fairy.annotation.FairyClient;
import org.noear.fairy.annotation.Mapping;

public class FairyHandler
implements InvocationHandler {
    private final FairyConfig config;
    private final Map<String, String> headers0 = new LinkedHashMap<String, String>();
    private final String name0;
    private final String path0;
    private final String url0;

    public FairyHandler(Class<?> clz, FairyConfig config, FairyClient client) {
        this.config = config;
        if (client != null) {
            try {
                FairyConfiguration tmp = client.configuration().newInstance();
                if (tmp != null) {
                    tmp.config(client, new Fairy.Builder(config));
                }
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
            if (client.headers() != null) {
                for (String h : client.headers()) {
                    String[] ss = h.split("=");
                    this.headers0.put(ss[0], ss[1]);
                }
            }
        }
        config.tryInit();
        String uri = config.getUri();
        if (uri == null && client != null && !FairyHandler.isEmpty(client.value())) {
            uri = client.value();
        }
        if (uri == null) {
            throw new FairyException("FairyClient config is wrong: " + clz.getName());
        }
        if (uri.contains("://")) {
            this.url0 = uri;
            this.name0 = null;
            this.path0 = null;
        } else if (uri.contains(":")) {
            this.url0 = null;
            this.name0 = uri.split(":")[0];
            this.path0 = uri.split(":")[1];
        } else {
            this.url0 = null;
            this.name0 = uri;
            this.path0 = null;
        }
        if (this.url0 == null && config.getUpstream() == null) {
            throw new FairyException("FairyClient: Not found upstream: " + clz.getName());
        }
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] vals) throws Throwable {
        String fun = method.getName();
        String met = null;
        Mapping mapping = method.getAnnotation(Mapping.class);
        if (mapping != null && !FairyHandler.isEmpty(mapping.value())) {
            String val = mapping.value().trim();
            if (val.indexOf(" ") > 0) {
                met = val.split(" ")[0];
                fun = val.split(" ")[1];
            } else {
                met = val;
            }
        }
        LinkedHashMap<String, Object> args = new LinkedHashMap<String, Object>();
        Parameter[] names = method.getParameters();
        int len = names.length;
        for (int i = 0; i < len; ++i) {
            if (vals[i] == null) continue;
            args.put(names[i].getName(), vals[i]);
        }
        HashMap<String, String> headers = new HashMap<String, String>(this.headers0);
        String url = null;
        if (this.url0 == null) {
            url = this.config.getUpstream().getServer();
            if (url == null) {
                throw new FairyException("FairyClient: Not found upstream!");
            }
            if (this.path0 != null) {
                int idx = url.indexOf("/", 9);
                if (idx > 0) {
                    url = url.substring(0, idx);
                }
                fun = this.path0.endsWith("/") ? this.path0 + fun : this.path0 + "/" + fun;
            }
        } else {
            url = this.url0;
        }
        return new Fairy(this.config).method(met).url(url, fun).call(headers, args).getObject(method.getReturnType());
    }

    private static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }
}

