/*
 * Decompiled with CFR 0.152.
 */
package org.noear.fairy.channel;

import java.io.ByteArrayInputStream;
import java.util.Map;
import okhttp3.MediaType;
import okhttp3.Response;
import org.noear.fairy.FairyConfig;
import org.noear.fairy.IChannel;
import org.noear.fairy.Result;
import org.noear.fairy.channel.OkHttpUtils;

public class OkHttpChannel
implements IChannel {
    public static final OkHttpChannel instance = new OkHttpChannel();

    @Override
    public Result call(FairyConfig cfg, String method, String url, Map<String, String> headers, Map<String, Object> args) throws Throwable {
        boolean is_get = "GET".equals(method);
        if (is_get && args.size() > 0) {
            StringBuilder sb = new StringBuilder(url).append("?");
            args.forEach((k, v) -> {
                if (v != null) {
                    sb.append((String)k).append("=").append(OkHttpUtils.urlEncode(v.toString())).append("&");
                }
            });
            url = sb.substring(0, sb.length() - 1);
        }
        cfg.getDecoder().filter(cfg, method, url, headers, args);
        OkHttpUtils http = OkHttpUtils.http(url).headers(headers);
        Response response = null;
        if (is_get) {
            response = http.exec("GET");
        } else {
            switch (cfg.getEncoder().enctype()) {
                case application_json: {
                    String json = (String)cfg.getEncoder().encode(args);
                    response = http.bodyTxt(json, "application/json").exec(method);
                    break;
                }
                case application_hessian: {
                    ByteArrayInputStream stream = new ByteArrayInputStream((byte[])cfg.getEncoder().encode(args));
                    response = http.bodyRaw(stream, "application/hessian").exec(method);
                    break;
                }
                case application_protobuf: {
                    ByteArrayInputStream stream = new ByteArrayInputStream((byte[])cfg.getEncoder().encode(args));
                    response = http.bodyRaw(stream, "application/protobuf").exec(method);
                    break;
                }
                default: {
                    response = args.size() == 0 ? http.exec("GET") : http.data(args).exec(method);
                }
            }
        }
        if (response == null) {
            return null;
        }
        Result result = new Result(response.code(), response.body().bytes());
        int len = response.headers().size();
        for (int i = 0; i < len; ++i) {
            result.headerAdd(response.headers().name(i), response.headers().value(i));
        }
        MediaType contentType = response.body().contentType();
        if (contentType != null) {
            result.charsetSet(contentType.charset());
        }
        return result;
    }
}

