/*
 * Decompiled with CFR 0.152.
 */
package org.noear.fairy.decoder;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.parser.ParserConfig;
import java.util.Map;
import org.noear.fairy.Enctype;
import org.noear.fairy.FairyConfig;
import org.noear.fairy.IDecoder;
import org.noear.fairy.Result;

public class FastjsonDecoder
implements IDecoder {
    public static final FastjsonDecoder instance;

    @Override
    public Enctype enctype() {
        return Enctype.application_json;
    }

    @Override
    public <T> T decode(Result rst, Class<T> clz) {
        String str = rst.bodyAsString();
        Object returnVal = null;
        try {
            if (str == null) {
                return (T)str;
            }
            returnVal = JSONObject.parseObject((String)str, (TypeReference)new TypeReference<T>(){}, (Feature[])new Feature[0]);
        }
        catch (Throwable ex) {
            returnVal = ex;
        }
        if (returnVal != null && Throwable.class.isAssignableFrom(returnVal.getClass())) {
            if (returnVal instanceof RuntimeException) {
                throw (RuntimeException)returnVal;
            }
            throw new RuntimeException((Throwable)returnVal);
        }
        return (T)returnVal;
    }

    @Override
    public void filter(FairyConfig cfg, String method, String url, Map<String, String> headers, Map<String, Object> args) {
        headers.put("X-Serialization", "@type_json");
    }

    static {
        ParserConfig.getGlobalInstance().setAutoTypeSupport(true);
        instance = new FastjsonDecoder();
    }
}

