/*
 * Decompiled with CFR 0.152.
 */
package org.noear.grit.client;

import java.sql.SQLException;
import org.noear.grit.client.GritClient;
import org.noear.grit.client.utils.TextUtils;
import org.noear.grit.model.domain.ResourceSpace;
import org.noear.grit.service.AuthService;
import org.noear.grit.service.ResourceLinkService;
import org.noear.grit.service.ResourceSchemaService;
import org.noear.grit.service.ResourceService;
import org.noear.grit.service.SubjectLinkService;
import org.noear.grit.service.SubjectService;
import org.noear.nami.Channel;
import org.noear.nami.Decoder;
import org.noear.nami.Encoder;
import org.noear.nami.Filter;
import org.noear.nami.Nami;
import org.noear.nami.NamiBuilder;
import org.noear.nami.NamiManager;
import org.noear.nami.channel.http.okhttp.HttpChannel;
import org.noear.nami.coder.snack3.SnackDecoder;
import org.noear.nami.coder.snack3.SnackEncoder;
import org.noear.solon.core.Bridge;
import org.noear.solon.core.LoadBalance;

public class GritClientRpcImpl
implements GritClient {
    private ResourceService resourceService;
    private ResourceLinkService resourceLinkService;
    private ResourceSchemaService resourceSchemaService;
    private SubjectService subjectService;
    private SubjectLinkService subjectLinkService;
    private AuthService authService;
    private long currentSpaceId;
    private String currentSpaceCode;

    public GritClientRpcImpl() {
        String gritServer = System.getProperty("grit.server");
        String gritToken = System.getProperty("grit.token");
        if (!TextUtils.isEmpty(gritServer) || !TextUtils.isEmpty(gritToken)) {
            this.resourceService = this.createService(gritServer, gritToken, ResourceService.class);
            this.resourceLinkService = this.createService(gritServer, gritToken, ResourceLinkService.class);
            this.subjectService = this.createService(gritServer, gritToken, SubjectService.class);
            this.subjectLinkService = this.createService(gritServer, gritToken, SubjectLinkService.class);
            this.authService = this.createService(gritServer, gritToken, AuthService.class);
            this.resourceSchemaService = this.createService(gritServer, gritToken, ResourceSchemaService.class);
        } else {
            if (TextUtils.isEmpty(gritServer)) {
                System.out.println("[Grit] Invalid configuration: grit.server");
            }
            if (TextUtils.isEmpty(gritToken)) {
                System.out.println("[Grit] Invalid configuration: grit.token");
            }
        }
    }

    private <T> T createService(String gritServer, String gritToken, Class<T> clz) {
        NamiBuilder namiBuilder = Nami.builder();
        String path = "/grit/api/v1/" + clz.getSimpleName();
        if (gritServer.startsWith("@")) {
            String name = gritServer.substring(1);
            namiBuilder.name(name).path(path);
            if (Bridge.upstreamFactory() != null) {
                LoadBalance loadBalance = Bridge.upstreamFactory().create("grit", name);
                namiBuilder.upstream(() -> ((LoadBalance)loadBalance).getServer());
            }
        } else {
            if (!gritServer.contains("://")) {
                gritServer = "http://" + gritServer;
            }
            namiBuilder.url(gritServer + path);
        }
        for (Filter mi : NamiManager.getFilters()) {
            namiBuilder.filterAdd(mi);
        }
        return (T)namiBuilder.encoder((Encoder)SnackEncoder.instance).decoder((Decoder)SnackDecoder.instance).channel((Channel)HttpChannel.instance).headerSet("Grit-Token", gritToken).create(clz);
    }

    @Override
    public void setCurrentSpaceByCode(String resourceSpaceCode) {
        if (resourceSpaceCode == null || resourceSpaceCode.equals(this.currentSpaceCode)) {
            return;
        }
        try {
            this.currentSpaceCode = resourceSpaceCode;
            ResourceSpace space = this.resource().getSpaceByCode(resourceSpaceCode);
            if (space.resource_id != null) {
                this.currentSpaceId = space.resource_id;
            } else {
                System.out.println("[Grit] Invalid resource space code: " + resourceSpaceCode);
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getCurrentSpaceCode() {
        return this.currentSpaceCode;
    }

    @Override
    public long getCurrentSpaceId() {
        return this.currentSpaceId;
    }

    @Override
    public ResourceService resource() {
        return this.resourceService;
    }

    @Override
    public ResourceLinkService resourceLink() {
        return this.resourceLinkService;
    }

    @Override
    public ResourceSchemaService resourceSchema() {
        return this.resourceSchemaService;
    }

    @Override
    public SubjectService subject() {
        return this.subjectService;
    }

    @Override
    public SubjectLinkService subjectLink() {
        return this.subjectLinkService;
    }

    @Override
    public AuthService auth() {
        return this.authService;
    }
}

